'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _parseToHsl = /*#__PURE__*/require('./parseToHsl');

var _parseToHsl2 = /*#__PURE__*/_interopRequireDefault(_parseToHsl);

var _toColorString = /*#__PURE__*/require('./toColorString');

var _toColorString2 = /*#__PURE__*/_interopRequireDefault(_toColorString);

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Sets the lightness of a color to the provided value. The lightness range can be
 * from 0 and 1.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: setLightness(0.2, '#CCCD64'),
 *   background: setLightness(0.75, 'rgba(204,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${setLightness(0.2, '#CCCD64')};
 *   background: ${setLightness(0.75, 'rgba(204,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 * element {
 *   background: "#4d4d19";
 *   background: "rgba(223,224,159,0.7)";
 * }
 */
function setLightness(lightness, color) {
  return (0, _toColorString2.default)(_extends({}, (0, _parseToHsl2.default)(color), {
    lightness: lightness
  }));
}

var curriedSetLightness = /*#__PURE__*/(0, _curry2.default)(setLightness);
exports.default = curriedSetLightness;
module.exports = exports['default'];