'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _parseToHsl = /*#__PURE__*/require('./parseToHsl');

var _parseToHsl2 = /*#__PURE__*/_interopRequireDefault(_parseToHsl);

var _toColorString = /*#__PURE__*/require('./toColorString');

var _toColorString2 = /*#__PURE__*/_interopRequireDefault(_toColorString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns the complement of the provided color. This is identical to adjustHue(180, <color>).
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: complement('#448'),
 *   background: complement('rgba(204,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${complement('#448')};
 *   background: ${complement('rgba(204,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 * element {
 *   background: "#884";
 *   background: "rgba(153,153,153,0.7)";
 * }
 */
function complement(color) {
  var hslColor = (0, _parseToHsl2.default)(color);
  return (0, _toColorString2.default)(_extends({}, hslColor, {
    hue: (hslColor.hue + 180) % 360
  }));
}

exports.default = complement;
module.exports = exports['default'];