'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

var _guard = /*#__PURE__*/require('../internalHelpers/_guard');

var _guard2 = /*#__PURE__*/_interopRequireDefault(_guard);

var _parseToHsl = /*#__PURE__*/require('./parseToHsl');

var _parseToHsl2 = /*#__PURE__*/_interopRequireDefault(_parseToHsl);

var _toColorString = /*#__PURE__*/require('./toColorString');

var _toColorString2 = /*#__PURE__*/_interopRequireDefault(_toColorString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns a string value for the darkened color.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: darken(0.2, '#FFCD64'),
 *   background: darken('0.2', 'rgba(255,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${darken(0.2, '#FFCD64')};
 *   background: ${darken('0.2', 'rgba(255,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 *
 * element {
 *   background: "#ffbd31";
 *   background: "rgba(255,189,49,0.7)";
 * }
 */
function darken(amount, color) {
  var hslColor = (0, _parseToHsl2.default)(color);
  return (0, _toColorString2.default)(_extends({}, hslColor, {
    lightness: (0, _guard2.default)(0, 1, hslColor.lightness - parseFloat(amount))
  }));
}

var curriedDarken = /*#__PURE__*/(0, _curry2.default)(darken);
exports.default = curriedDarken;
module.exports = exports['default'];