'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

var _parseToHsl = /*#__PURE__*/require('./parseToHsl');

var _parseToHsl2 = /*#__PURE__*/_interopRequireDefault(_parseToHsl);

var _toColorString = /*#__PURE__*/require('./toColorString');

var _toColorString2 = /*#__PURE__*/_interopRequireDefault(_toColorString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Sets the hue of a color to the provided value. The hue range can be
 * from 0 and 359.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: setHue(42, '#CCCD64'),
 *   background: setHue('244', 'rgba(204,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${setHue(42, '#CCCD64')};
 *   background: ${setHue('244', 'rgba(204,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 * element {
 *   background: "#cdae64";
 *   background: "rgba(107,100,205,0.7)";
 * }
 */
function setHue(hue, color) {
  return (0, _toColorString2.default)(_extends({}, (0, _parseToHsl2.default)(color), {
    hue: parseFloat(hue)
  }));
}

var curriedSetHue = /*#__PURE__*/(0, _curry2.default)(setHue);
exports.default = curriedSetHue;
module.exports = exports['default'];