'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

var _mix = /*#__PURE__*/require('./mix');

var _mix2 = /*#__PURE__*/_interopRequireDefault(_mix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Shades a color by mixing it with black. `shade` can produce
 * hue shifts, where as `darken` manipulates the luminance channel and therefore
 * doesn't produce hue shifts.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: shade(0.25, '#00f')
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${shade(0.25, '#00f')};
 * `
 *
 * // CSS in JS Output
 *
 * element {
 *   background: "#00003f";
 * }
 */

function shade(percentage, color) {
  return (0, _mix2.default)(parseFloat(percentage), color, 'rgb(0, 0, 0)');
}

var curriedShade = /*#__PURE__*/(0, _curry2.default)(shade);
exports.default = curriedShade;
module.exports = exports['default'];