'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _curry = /*#__PURE__*/require('../internalHelpers/_curry');

var _curry2 = /*#__PURE__*/_interopRequireDefault(_curry);

var _mix = /*#__PURE__*/require('./mix');

var _mix2 = /*#__PURE__*/_interopRequireDefault(_mix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Tints a color by mixing it with white. `tint` can produce
 * hue shifts, where as `lighten` manipulates the luminance channel and therefore
 * doesn't produce hue shifts.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: tint(0.25, '#00f')
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${tint(0.25, '#00f')};
 * `
 *
 * // CSS in JS Output
 *
 * element {
 *   background: "#bfbfff";
 * }
 */

function tint(percentage, color) {
  return (0, _mix2.default)(parseFloat(percentage), color, 'rgb(255, 255, 255)');
}

var curriedTint = /*#__PURE__*/(0, _curry2.default)(tint);
exports.default = curriedTint;
module.exports = exports['default'];