'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _borderColor = /*#__PURE__*/require('../shorthands/borderColor');

var _borderColor2 = /*#__PURE__*/_interopRequireDefault(_borderColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getBorderWidth = function getBorderWidth(pointingDirection, height, width) {
  switch (pointingDirection) {
    case 'top':
      return '0 ' + width[0] / 2 + width[1] + ' ' + height[0] + height[1] + ' ' + width[0] / 2 + width[1];
    case 'left':
      return '' + height[0] / 2 + height[1] + ' ' + width[0] + width[1] + ' ' + height[0] / 2 + height[1] + ' 0';
    case 'bottom':
      return '' + height[0] + height[1] + ' ' + width[0] / 2 + width[1] + ' 0 ' + width[0] / 2 + width[1];
    case 'right':
      return '' + height[0] / 2 + height[1] + ' 0 ' + height[0] / 2 + height[1] + ' ' + width[0] + width[1];

    default:
      throw new Error("Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.");
  }
};

// needed for border-color
var reverseDirection = ['bottom', 'left', 'top', 'right'];

/**
 * CSS to represent triangle with any pointing direction with an optional background color. Accepts number or px values for height and width.
 *
 * @example
 * // Styles as object usage
 *
 * const styles = {
 *   ...triangle({ pointingDirection: 'right', width: '100px', height: '100px', foregroundColor: 'red' })
 * }
 *
 *
 * // styled-components usage
 * const div = styled.div`
 *   ${triangle({ pointingDirection: 'right', width: '100px', height: '100px', foregroundColor: 'red' })}
 *
 *
 * // CSS as JS Output
 *
 * div: {
 *  'borderColor': 'transparent',
 *  'borderLeftColor': 'red !important',
 *  'borderStyle': 'solid',
 *  'borderWidth': '50px 0 50px 100px',
 *  'height': '0',
 *  'width': '0',
 * }
 */
function triangle(_ref) {
  var pointingDirection = _ref.pointingDirection,
      height = _ref.height,
      width = _ref.width,
      foregroundColor = _ref.foregroundColor,
      _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === undefined ? 'transparent' : _ref$backgroundColor;

  var widthAndUnit = [parseFloat(width), String(width).replace(/\d+/g, '') || 'px'];
  var heightAndUnit = [parseFloat(height), String(height).replace(/\d+/g, '') || 'px'];
  if (isNaN(heightAndUnit[0]) || isNaN(widthAndUnit[0])) {
    throw new Error('Passed an invalid value to `height` or `width`. Please provide a pixel based unit');
  }

  var reverseDirectionIndex = reverseDirection.indexOf(pointingDirection);
  return _extends({
    width: '0',
    height: '0',
    borderWidth: getBorderWidth(pointingDirection, heightAndUnit, widthAndUnit),
    borderStyle: 'solid'
  }, _borderColor2.default.apply(undefined, Array.from({ length: 4 }).map(function (_, index) {
    return index === reverseDirectionIndex ? foregroundColor : backgroundColor;
  })));
}

exports.default = triangle;
module.exports = exports['default'];