"use strict";

exports.__esModule = true;
exports.default = void 0;

var _curry =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("../internalHelpers/_curry"));

var _parseToHsl =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./parseToHsl"));

var _toColorString =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./toColorString"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Sets the hue of a color to the provided value. The hue range can be
 * from 0 and 359.
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: setHue(42, '#CCCD64'),
 *   background: setHue('244', 'rgba(204,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${setHue(42, '#CCCD64')};
 *   background: ${setHue('244', 'rgba(204,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 * element {
 *   background: "#cdae64";
 *   background: "rgba(107,100,205,0.7)";
 * }
 */
function setHue(hue, color) {
  return (0, _toColorString.default)(_extends({}, (0, _parseToHsl.default)(color), {
    hue: parseFloat(hue)
  }));
} // prettier-ignore


var curriedSetHue =
/*#__PURE__*/
(0, _curry.default
/* ::<number | string, string, string> */
)(setHue);
var _default = curriedSetHue;
exports.default = _default;
module.exports = exports.default;