"use strict";

exports.__esModule = true;
exports.default = void 0;

var _getLuminance =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./getLuminance"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns black or white (or optional light and dark return colors) for best contrast depending on the luminosity of the given color.
 * Follows [W3C specs for readability](https://www.w3.org/TR/WCAG20-TECHS/G18.html).
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   color: readableColor('#000'),
 *   color: readableColor('black', '#001', '#ff8'),
 *   color: readableColor('white', '#001', '#ff8'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   color: ${readableColor('#000')};
 *   color: ${readableColor('black', '#001', '#ff8')};
 *   color: ${readableColor('white', '#001', '#ff8')};
 * `
 *
 * // CSS in JS Output
 *
 * element {
 *   color: "#fff";
 *   color: "#ff8";
 *   color: "#001";
 * }
 */
function readableColor(color, lightReturnColor, darkReturnColor) {
  if (lightReturnColor === void 0) {
    lightReturnColor = '#000';
  }

  if (darkReturnColor === void 0) {
    darkReturnColor = '#fff';
  }

  return (0, _getLuminance.default)(color) > 0.179 ? lightReturnColor : darkReturnColor;
}

var _default = readableColor;
exports.default = _default;
module.exports = exports.default;