"use strict";

exports.__esModule = true;
exports.default = void 0;

var _parseToHsl =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./parseToHsl"));

var _toColorString =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./toColorString"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Returns the complement of the provided color. This is identical to adjustHue(180, <color>).
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   background: complement('#448'),
 *   background: complement('rgba(204,205,100,0.7)'),
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   background: ${complement('#448')};
 *   background: ${complement('rgba(204,205,100,0.7)')};
 * `
 *
 * // CSS in JS Output
 * element {
 *   background: "#884";
 *   background: "rgba(153,153,153,0.7)";
 * }
 */
function complement(color) {
  if (color === 'transparent') return color;
  var hslColor = (0, _parseToHsl.default)(color);
  return (0, _toColorString.default)(_extends({}, hslColor, {
    hue: (hslColor.hue + 180) % 360
  }));
}

var _default = complement;
exports.default = _default;
module.exports = exports.default;