"use strict";

exports.__esModule = true;
exports.default = void 0;

var _stripUnit5 =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("../helpers/stripUnit"));

var _errors =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("../internalHelpers/_errors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns a CSS calc formula for linear interpolation of a property between two values. Accepts optional minScreen (defaults to '320px') and maxScreen (defaults to '1200px').
 *
 * @example
 * // Styles as object usage
 * const styles = {
 *   fontSize: between('20px', '100px', '400px', '1000px'),
 *   fontSize: between('20px', '100px')
 * }
 *
 * // styled-components usage
 * const div = styled.div`
 *   fontSize: ${between('20px', '100px', '400px', '1000px')};
 *   fontSize: ${between('20px', '100px')}
 * `
 *
 * // CSS as JS Output
 *
 * h1: {
 *   'fontSize': 'calc(-33.33333333333334px + 13.333333333333334vw)',
 *   'fontSize': 'calc(-9.090909090909093px + 9.090909090909092vw)'
 * }
 */
function between(fromSize, toSize, minScreen, maxScreen) {
  if (minScreen === void 0) {
    minScreen = '320px';
  }

  if (maxScreen === void 0) {
    maxScreen = '1200px';
  }

  var _stripUnit = (0, _stripUnit5.default)(fromSize, true),
      unitlessFromSize = _stripUnit[0],
      fromSizeUnit = _stripUnit[1];

  var _stripUnit2 = (0, _stripUnit5.default)(toSize, true),
      unitlessToSize = _stripUnit2[0],
      toSizeUnit = _stripUnit2[1];

  var _stripUnit3 = (0, _stripUnit5.default)(minScreen, true),
      unitlessMinScreen = _stripUnit3[0],
      minScreenUnit = _stripUnit3[1];

  var _stripUnit4 = (0, _stripUnit5.default)(maxScreen, true),
      unitlessMaxScreen = _stripUnit4[0],
      maxScreenUnit = _stripUnit4[1];

  if (typeof unitlessMinScreen !== 'number' || typeof unitlessMaxScreen !== 'number' || !minScreenUnit || !maxScreenUnit || minScreenUnit !== maxScreenUnit) {
    throw new _errors.default(47);
  }

  if (typeof unitlessFromSize !== 'number' || typeof unitlessToSize !== 'number' || !fromSizeUnit || !toSizeUnit || fromSizeUnit !== toSizeUnit) {
    throw new _errors.default(48);
  }

  var slope = (unitlessFromSize - unitlessToSize) / (unitlessMinScreen - unitlessMaxScreen);
  var base = unitlessToSize - slope * unitlessMaxScreen;
  return "calc(" + base.toFixed(2) + fromSizeUnit + " + " + (100 * slope).toFixed(2) + "vw)";
}

var _default = between;
exports.default = _default;
module.exports = exports.default;