"use strict";

exports.__esModule = true;
exports["default"] = hslToColorString;

var _hsl =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./hsl"));

var _hsla =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./hsla"));

var _errors =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("../internalHelpers/_errors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function hslToColorString(color) {
  if (typeof color === 'object' && typeof color.hue === 'number' && typeof color.saturation === 'number' && typeof color.lightness === 'number') {
    if (color.alpha && typeof color.alpha === 'number') {
      return (0, _hsla["default"])({
        hue: color.hue,
        saturation: color.saturation,
        lightness: color.lightness,
        alpha: color.alpha
      });
    }

    return (0, _hsl["default"])({
      hue: color.hue,
      saturation: color.saturation,
      lightness: color.lightness
    });
  }

  throw new _errors["default"](45);
}

module.exports = exports.default;