"use strict";

exports.__esModule = true;
exports["default"] = rgbToColorString;

var _rgb =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./rgb"));

var _rgba =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("./rgba"));

var _errors =
/*#__PURE__*/
_interopRequireDefault(
/*#__PURE__*/
require("../internalHelpers/_errors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function rgbToColorString(color) {
  if (typeof color === 'object' && typeof color.red === 'number' && typeof color.green === 'number' && typeof color.blue === 'number') {
    if (color.alpha && typeof color.alpha === 'number') {
      return (0, _rgba["default"])({
        red: color.red,
        green: color.green,
        blue: color.blue,
        alpha: color.alpha
      });
    }

    return (0, _rgb["default"])({
      red: color.red,
      green: color.green,
      blue: color.blue
    });
  }

  throw new _errors["default"](46);
}

module.exports = exports.default;