import Vue from 'vue';
import { SelectOption } from './types';
interface ComponentData {
    activeIndex: number;
    callFocus: boolean;
    htmlId: string;
    ignoreBlur: boolean;
    notificationMessage: string;
    open: boolean;
    inputValue: string;
}
interface ISelectMulti extends Vue {
    $refs: {
        inputRef: HTMLInputElement;
        listboxRef: HTMLElement;
        activeOptionRef: HTMLElement;
        selectedOptionPill: HTMLElement;
    };
}
declare const _default: import("vue/types/vue").ExtendedVue<ISelectMulti, ComponentData, {
    onInput(): void;
    determineMenuStateAndNotificationMessage(): void;
    onInputKeyDown(event: KeyboardEvent): any;
    onInputBlur(): void;
    onOptionChange(index: number): void;
    onOptionClick(index: number): void;
    onOptionMouseDown(event: MouseEvent): void;
    onMenuMouseDown(event: MouseEvent): void;
    removeOption(index: number): void;
    removeOptionAndHandleFocusShift(index: number): void;
    selectOption(option: SelectOption): void;
    updateOption(index: number): void;
    updateMenuState(open: boolean, callFocus?: boolean): void;
}, {
    activeId: string;
    filteredOptions: SelectOption[];
    selectedOptions: SelectOption[];
    displayNoResultsMessage: boolean;
}, {
    disabled: boolean;
    label: string;
    labelField: string;
    loading: boolean;
    options: SelectOption[];
    labelIsVisible: boolean;
    placeholder: any;
    internalSearch: boolean;
    optionLabelForSearching: (option: SelectOption) => string;
    displayPillsBelowInput: boolean;
    noResultsMessage: string;
    values: any[];
    uniqueIdField: string;
}>;
/**
 * Component to select multiple options from a dropdown, developed with accessibility & usability as the primary focus
 */
export default _default;
