import Vue from 'vue';
import { SelectOption } from './types';
import { MenuActions } from './shared';
interface ComponentData {
    activeIndex: number;
    htmlId: string;
    ignoreBlur: boolean;
    inputValue: string;
    open: boolean;
    searchString: string;
    searchTimeout: number | null;
}
interface ISelectSingle extends Vue {
    $refs: {
        comboEl: HTMLElement;
    };
}
declare const _default: import("vue/types/vue").ExtendedVue<ISelectSingle, ComponentData, {
    getSearchString(char: string): any;
    getUpdatedIndex(current: number, max: number, action: MenuActions): number;
    handleBlur(): void;
    handleClick(): void;
    updateMenuState(open: boolean, callFocus?: boolean): void;
    handleKeydown(event: KeyboardEvent): any;
    handleOptionClick(event: MouseEvent, index: number): void;
    onOptionMouseDown(event: MouseEvent): void;
    onMenuMouseDown(event: MouseEvent): void;
    onOptionChange(index: number): void;
    selectOption(index: number): void;
}, {
    activeDescendant: string;
    isCurrentOptionDisabled: boolean;
    isDisabledOrLoading: boolean;
    isPlaceholderShown: boolean;
    selectedIndex: number;
}, {
    disabled: boolean;
    label: string;
    labelField: string;
    labelIsVisible: boolean;
    loading: boolean;
    options: SelectOption[];
    placeholder: string;
    value: SelectOption;
    uniqueIdField: string;
}>;
/**
 * Component to select a single option from a dropdown, developed with accessibility & usability as the primary focus
 */
export default _default;
