import Vue from 'vue';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT license. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// filter an array of options against an input string
// returns an array of options that begin with the filter string, case-independent
function filterOptions(options, filter, labelField, exclude, optionLabelForSearching) {
    if (options === void 0) { options = []; }
    if (exclude === void 0) { exclude = []; }
    if (optionLabelForSearching === void 0) { optionLabelForSearching = null; }
    return options.filter(function (option) {
        // NOTE: Changed from original implementation on sonder-ui:
        // we want to match any instance of the current user string,
        // rather than *only* when the user's string is at the beginning of an option
        var label = optionLabelForSearching ? optionLabelForSearching(option) : option[labelField];
        var matches = label === null || label === void 0 ? void 0 : label.toLowerCase().includes(filter.toLowerCase());
        return matches && exclude.indexOf(option) < 0;
    });
}
// unused
// // User-defined Type Guard: https://stackoverflow.com/a/46700791/4167438
// function notEmpty<TValue>(value: TValue | null | undefined): value is TValue {
// 	return value !== null && value !== undefined
// }
// unused
// // return an array of exact option name matches from a comma-separated string
// export function findMatches(options: SelectOption[], search: string): SelectOption[] {
// 	const labels = search.split(',')
// 	return labels
// 		.map(label => {
// 			const match = options.filter(
// 				option => label.trim().toLowerCase() === option.label.toLowerCase()
// 			)
// 			return match.length > 0 ? match[0] : null
// 		})
// 		.filter(notEmpty)
// }
// return combobox action from key press
function getActionFromKey(event, menuOpen, isCurrentOptionDisabled) {
    if (isCurrentOptionDisabled === void 0) { isCurrentOptionDisabled = false; }
    var key = event.key, altKey = event.altKey, ctrlKey = event.ctrlKey, metaKey = event.metaKey;
    var openKeys = ['ArrowDown', 'ArrowUp', 'Enter', ' ', 'Home', 'End']; // all keys that will open the combo
    // handle opening when closed
    if (!menuOpen && openKeys.includes(key)) {
        return 5 /* Open */;
    }
    // handle typing characters when open or closed
    if (key === "Backspace" /* Backspace */ ||
        key === "Clear" /* Clear */ ||
        ((key === null || key === void 0 ? void 0 : key.length) === 1 && key !== ' ' && !altKey && !ctrlKey && !metaKey)) {
        return 11 /* Type */;
    }
    // handle keys when open
    if (menuOpen) {
        if (key === "ArrowDown" /* Down */ && !altKey) {
            return 4 /* Next */;
        }
        else if (key === "ArrowUp" /* Up */ && altKey) {
            return 1 /* CloseSelect */;
        }
        else if (key === "ArrowUp" /* Up */) {
            return 8 /* Previous */;
        }
        else if (key === "Home" /* Home */) {
            return 2 /* First */;
        }
        else if (key === "End" /* End */) {
            return 3 /* Last */;
        }
        else if (key === "PageUp" /* PageUp */) {
            return 7 /* PageUp */;
        }
        else if (key === "PageDown" /* PageDown */) {
            return 6 /* PageDown */;
        }
        else if (key === "Escape" /* Escape */) {
            return 0 /* Close */;
        }
        else if (key === "Enter" /* Enter */) {
            return isCurrentOptionDisabled ? undefined : 1 /* CloseSelect */;
        }
        else if (key === " " /* Space */) {
            return isCurrentOptionDisabled ? undefined : 10 /* Space */;
        }
    }
}
// return the index of an option from an array of options, based on a search string
// if the filter is multiple iterations of the same letter (e.g "aaa"), then cycle through first-letter matches
function getIndexByLetter(options, filter, labelField, startIndex) {
    if (startIndex === void 0) { startIndex = 0; }
    var orderedOptions = __spreadArrays(options.slice(startIndex), options.slice(0, startIndex));
    var firstMatch = filterOptions(orderedOptions, filter, labelField)[0];
    var allSameLetter = function (array) { return array.every(function (letter) { return letter === array[0]; }); };
    // first check if there is an exact match for the typed string
    if (firstMatch) {
        return options.indexOf(firstMatch);
    }
    // if the same letter is being repeated, cycle through first-letter matches
    else if (allSameLetter(filter.split(''))) {
        var matches = filterOptions(orderedOptions, filter[0], labelField);
        return options.indexOf(matches[0]);
    }
    // if no matches, return -1
    else {
        return -1;
    }
}
// get updated option index
function getUpdatedIndex(current, max, action) {
    switch (action) {
        case 2 /* First */:
            return 0;
        case 3 /* Last */:
            return max;
        case 8 /* Previous */:
            return Math.max(0, current - 1);
        case 4 /* Next */:
            return Math.min(max, current + 1);
        default:
            return current;
    }
}
// check if an element is currently scrollable
function isScrollable(element) {
    return element && element.clientHeight < element.scrollHeight;
}
// ensure given child element is within the parent's visible scroll area
function maintainScrollVisibility(activeElement, scrollParent) {
    var offsetHeight = activeElement.offsetHeight, offsetTop = activeElement.offsetTop;
    var _a = activeElement.getBoundingClientRect(), bottom = _a.bottom, top = _a.top;
    var parentOffsetHeight = scrollParent.offsetHeight, scrollTop = scrollParent.scrollTop;
    var isAboveParent = offsetTop < scrollTop;
    var isBelowParent = offsetTop + offsetHeight > scrollTop + parentOffsetHeight;
    var isBelowScreen = bottom > document.documentElement.clientHeight;
    var isAboveScreen = top < 0;
    if (isBelowScreen) {
        return activeElement.scrollIntoView(false);
    }
    if (isAboveScreen) {
        return (scrollParent.scrollTop = 0);
    }
    if (isBelowParent) {
        return (scrollParent.scrollTop = offsetTop + offsetHeight - parentOffsetHeight);
    }
    if (isAboveParent) {
        return (scrollParent.scrollTop = offsetTop);
    }
}
// generate unique ID, the quick 'n dirty way
var idIndex = 0;
function uniqueId() {
    return "sui-" + ++idIndex;
}

// Original reference: https://github.com/microsoft/sonder-ui/tree/master/src/components/select
/**
 * Component to select a single option from a dropdown, developed with accessibility & usability as the primary focus
 */
// `PURE` designation to enable tree-shaking
var script = /*#__PURE__*/ Vue.extend({
    name: 'SelectSingle',
    model: {
        prop: 'value',
        event: 'select'
    },
    props: {
        disabled: {
            type: Boolean,
            default: false
        },
        label: {
            type: String,
            required: true
        },
        /**
         * Field name in the `options` array that should be used for displaying the label
         * Values in this field do not need to be unique - they are used for display only
         */
        labelField: {
            type: String,
            required: false,
            default: 'label'
        },
        labelIsVisible: {
            type: Boolean,
            default: true
        },
        loading: {
            type: Boolean,
            default: false
        },
        options: {
            required: true,
            type: Array
        },
        placeholder: {
            type: String,
            default: ''
        },
        /** Generally, there's no need to set this via a prop - it will be set automatically when using v-model */
        value: {
            default: null,
            required: false,
            type: Object
        },
        /**
         * Field name in the `options` array that should be used as the **unique** identifier for each option
         * Required in order to disambiguate between options, when indicating which options are selected, for example
         *
         * @example
         * ```
         * options = [{ label: 'One', id: 1 },{ label: 'Two', id: 2 }]
         * ```
         * ```
         * <SelectSingle :options="options" uniqueIdField="id" />
         * ```
         */
        uniqueIdField: {
            type: String,
            required: false,
            default: 'value'
        }
        // Potential props:
        // https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select
        // size
        // autofocus
        // required
    },
    data: function () {
        var _this = this;
        var activeIndex = this.value
            ? this.options.findIndex(function (currentOption) { return currentOption[_this.uniqueIdField] == _this.value[_this.uniqueIdField]; })
            : 0;
        return {
            activeIndex: activeIndex,
            htmlId: uniqueId(),
            ignoreBlur: false,
            open: false,
            searchString: '',
            searchTimeout: null,
            inputValue: ''
        };
    },
    computed: {
        activeDescendant: function () {
            return this.htmlId + "-item-" + this.activeIndex;
        },
        isCurrentOptionDisabled: function () {
            var _a;
            return ((_a = this.options[this.activeIndex]) === null || _a === void 0 ? void 0 : _a.disabled) || false;
        },
        isDisabledOrLoading: function () {
            return this.disabled || this.loading;
        },
        isPlaceholderShown: function () {
            var _a;
            return this.placeholder && !((_a = this.value) === null || _a === void 0 ? void 0 : _a.value);
        },
        selectedIndex: function () {
            var _this = this;
            return this.value
                ? this.options.findIndex(function (currentOption) { return currentOption.value == _this.value.value; })
                : 0;
        }
    },
    watch: {
        selectedIndex: function (newValue) {
            this.activeIndex = newValue;
        }
    },
    updated: function () {
        var _a, _b;
        if (this.open && ((_b = (_a = this.$refs) === null || _a === void 0 ? void 0 : _a.activeOptionRef) === null || _b === void 0 ? void 0 : _b[0]) && isScrollable(this.$refs.listboxEl)) {
            maintainScrollVisibility(this.$refs.activeOptionRef[0], this.$refs.listboxEl);
        }
    },
    methods: {
        getSearchString: function (char) {
            var _this = this;
            var multimatchTimeout = 500;
            // reset typing timeout and start new timeout
            // this allows us to make multiple-letter matches, like a native select
            if (typeof this.searchTimeout === 'number') {
                window.clearTimeout(this.searchTimeout);
            }
            this.searchTimeout = window.setTimeout(function () {
                _this.searchString = '';
            }, multimatchTimeout);
            // add most recent letter to saved search string
            this.searchString += char;
            return this.searchString;
        },
        getUpdatedIndex: function (current, max, action) {
            switch (action) {
                case 2 /* First */:
                    return 0;
                case 3 /* Last */:
                    return max;
                case 8 /* Previous */:
                    return Math.max(0, current - 1);
                case 4 /* Next */:
                    return Math.min(max, current + 1);
                default:
                    return current;
            }
        },
        handleBlur: function () {
            if (this.ignoreBlur) {
                this.ignoreBlur = false;
                return;
            }
            if (this.open) {
                this.open = false;
                // this.updateMenuState(false, false);
            }
        },
        handleClick: function () {
            this.open = !this.open;
        },
        updateMenuState: function (open, callFocus) {
            if (callFocus === void 0) { callFocus = true; }
            this.open = open;
            callFocus && this.$refs.comboEl.focus();
        },
        handleKeydown: function (event) {
            var key = event.key;
            var max = this.options.length - 1;
            var action = getActionFromKey(event, this.open, this.isCurrentOptionDisabled);
            switch (action) {
                case 4 /* Next */:
                case 3 /* Last */:
                case 2 /* First */:
                case 8 /* Previous */:
                    event.preventDefault();
                    return this.onOptionChange(this.getUpdatedIndex(this.activeIndex, max, action));
                case 1 /* CloseSelect */:
                case 10 /* Space */:
                    event.preventDefault();
                    this.selectOption(this.activeIndex);
                    this.updateMenuState(false, false);
                    break;
                case 0 /* Close */:
                    this.activeIndex = this.selectedIndex;
                    this.updateMenuState(false, false);
                    break;
                case 11 /* Type */: {
                    this.updateMenuState(true);
                    var searchString = this.getSearchString(key);
                    return this.onOptionChange(Math.max(0, getIndexByLetter(this.options, searchString, this.labelField)));
                }
                case 5 /* Open */:
                    event.preventDefault();
                    return this.updateMenuState(true);
            }
        },
        handleOptionClick: function (event, index) {
            this.selectOption(index);
            this.updateMenuState(false);
        },
        onOptionMouseDown: function (event) {
            this.ignoreBlur = true;
            event.stopPropagation();
        },
        onMenuMouseDown: function (event) {
            event.preventDefault();
        },
        onOptionChange: function (index) {
            this.activeIndex = index;
        },
        selectOption: function (index) {
            var selected = this.options[index];
            this.inputValue = selected[this.labelField];
            /**
             * emit the most recently selected value,
             * *generally not necessary*, if state can be handled w/ v-model alone
             */
            this.$emit('select', selected);
        }
    }
});

function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    // Vue.extend constructor export interop.
    const options = typeof script === 'function' ? script.options : script;
    // render functions
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        // functional template
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    // scopedId
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        // server build
        hook = function (context) {
            // 2.3 injection
            context =
                context || // cached call
                    (this.$vnode && this.$vnode.ssrContext) || // stateful
                    (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
            // 2.2 with runInNewContext: true
            if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                context = __VUE_SSR_CONTEXT__;
            }
            // inject component styles
            if (style) {
                style.call(this, createInjectorSSR(context));
            }
            // register component module identifier for async chunk inference
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        // used by ssr in case component is cached and beforeCreate
        // never gets called
        options._ssrRegister = hook;
    }
    else if (style) {
        hook = shadowMode
            ? function (context) {
                style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
            }
            : function (context) {
                style.call(this, createInjector(context));
            };
    }
    if (hook) {
        if (options.functional) {
            // register for functional component in vue file
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        }
        else {
            // inject component registration as beforeCreate hook
            const existing = options.beforeCreate;
            options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
        }
    }
    return script;
}

/* script */
const __vue_script__ = script;

/* template */
var __vue_render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"vue-accessible-select-single",class:{ disabled: _vm.isDisabledOrLoading, open: _vm.open }},[_c('label',{staticClass:"combo-label",class:{ 'sr-only': !_vm.labelIsVisible },attrs:{"id":(_vm.htmlId + "-label")}},[_vm._v("\n\t\t"+_vm._s(_vm.label)+"\n\t\t"),_c('span',{staticClass:"sr-only"},[_vm._v(" "+_vm._s(_vm.value[_vm.labelField]))])]),_vm._v(" "),_c('div',_vm._g({ref:"comboEl",staticClass:"combo-input",attrs:{"id":_vm.htmlId,"aria-activedescendant":_vm.activeDescendant,"aria-autocomplete":"none","aria-controls":(_vm.htmlId + "-listbox"),"aria-disabled":_vm.isDisabledOrLoading,"aria-expanded":_vm.open ? 'true' : 'false',"aria-haspopup":"listbox","aria-labelledby":(_vm.htmlId + "-label"),"role":"combobox","tabindex":"0"},on:{"blur":_vm.handleBlur}},_vm.isDisabledOrLoading ? {} : { mousedown: _vm.handleClick, keydown: _vm.handleKeydown }),[_c('span',{ref:"valueEl",attrs:{"id":(_vm.htmlId + "-value")}},[(_vm.loading)?_vm._t("loadingState",[_vm._v("\n\t\t\t\tLoading...\n\t\t\t")]):(_vm.isPlaceholderShown)?_c('span',{staticClass:"combo-placeholder"},[_vm._v(_vm._s(_vm.placeholder))]):_vm._t("selectedOption",[_vm._v("\n\t\t\t\t"+_vm._s(_vm.value[_vm.labelField])+"\n\t\t\t")],{"option":_vm.value})],2)]),_vm._v(" "),_c('div',{ref:"listboxEl",staticClass:"combo-menu",attrs:{"id":(_vm.htmlId + "-listbox"),"role":"listbox"},on:{"mousedown":_vm.onMenuMouseDown}},_vm._l((_vm.options),function(option,index){return _c('div',{key:option[_vm.uniqueIdField].toString(),ref:_vm.activeIndex === index ? 'activeOptionRef' : null,refInFor:true,staticClass:"combo-option",class:{
				'option-selected': _vm.selectedIndex == index,
				'option-current': index == _vm.activeIndex,
				'option-disabled': option.disabled
			},attrs:{"id":(_vm.htmlId + "-item-" + index),"role":"option","aria-disabled":option.disabled,"aria-selected":index == _vm.selectedIndex ? 'true' : 'false'},on:{"click":function($event){return _vm.handleOptionClick($event, index)},"mousedown":_vm.onOptionMouseDown}},[_vm._t("option",[_vm._v("\n\t\t\t\t"+_vm._s(option[_vm.labelField])+"\n\t\t\t")],{"option":option})],2)}),0)])};
var __vue_staticRenderFns__ = [];

  /* style */
  const __vue_inject_styles__ = undefined;
  /* scoped */
  const __vue_scope_id__ = undefined;
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__ = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    false,
    undefined,
    undefined,
    undefined
  );

// Original reference: https://github.com/microsoft/sonder-ui/tree/master/src/components/multiselect
/**
 * Component to select multiple options from a dropdown, developed with accessibility & usability as the primary focus
 */
// `PURE` designation to enable tree-shaking
var script$1 = /*#__PURE__*/ Vue.extend({
    name: 'SelectMulti',
    model: {
        prop: 'values',
        event: 'change'
    },
    props: {
        disabled: {
            type: Boolean,
            default: false
        },
        label: {
            type: String,
            required: true
        },
        /**
         * Field name in the `options` array that should be used for displaying the label
         * Values in this field do not need to be unique - they are used for display only
         */
        labelField: {
            type: String,
            required: false,
            default: 'label'
        },
        loading: {
            type: Boolean,
            default: false
        },
        options: {
            type: Array,
            required: true
        },
        labelIsVisible: {
            type: Boolean,
            required: false,
            default: true
        },
        placeholder: {
            type: String,
            required: false,
            default: function () { return null; }
        },
        /**
         * Determines whether or not typing in the input will filter the provided options.
         * Should be set to false if you are making API calls to fetch options.
         */
        internalSearch: {
            type: Boolean,
            required: false,
            default: true
        },
        /**
         * When using a slot to display each option in the select,
         * you'll want to pass in a way for the select to *search* for those options as a user types,
         * in order to accurately filter the available options
         * @example
         * ```
         * :optionLabelForSearching="a => a.label + '-' + a.value"
         * ```
         */
        optionLabelForSearching: {
            type: Function,
            required: false,
            default: null
        },
        displayPillsBelowInput: {
            type: Boolean,
            default: false
        },
        /**
         * By default, the list will be empty when either no options are passed in,
         * or a user has typed a string that doesn't match any of the options.
         * If you'd like to display a messsage instead when that occurs, pass it in here
         */
        noResultsMessage: {
            type: String,
            default: ''
        },
        /** Generally, there's no need to set this via a prop - it will be set automatically when using v-model */
        values: {
            type: Array,
            required: false,
            default: function () { return []; }
        },
        /**
         * Field name in the `options` array that should be used as the **unique** identifier for each option
         * Required in order to disambiguate between options, when indicating which options are selected, for example
         *
         * @example
         * ```
         * options = [{ label: 'One', id: 1 },{ label: 'Two', id: 2 }]
         * ```
         * ```
         * <SelectMulti :options="options" uniqueIdField="id" />
         * ```
         */
        uniqueIdField: {
            type: String,
            required: false,
            default: 'value'
        }
    },
    data: function () {
        return {
            activeIndex: 0,
            callFocus: false,
            htmlId: uniqueId(),
            ignoreBlur: false,
            notificationMessage: '',
            open: false,
            inputValue: ''
        };
    },
    watch: {
        loading: function (newLoadingState, oldLoadingState) {
            // In cases where we move from a loading state, to a resolved state...
            if (newLoadingState === false && oldLoadingState === true) {
                //... we want to open the options to show the newly fetched items.
                this.updateMenuState(true);
            }
        }
    },
    computed: {
        activeId: function () {
            return this.open ? this.htmlId + "-" + this.activeIndex : '';
        },
        filteredOptions: function () {
            return this.internalSearch ? filterOptions(this.options, this.inputValue, this.labelField, [], this.optionLabelForSearching) : this.options;
        },
        selectedOptions: {
            get: function () {
                return this.values;
            },
            set: function (values) {
                // Used just for v-model, no need to subscribe to handle event
                this.$emit('change', values);
            }
        },
        displayNoResultsMessage: function () {
            return this.noResultsMessage && (!this.filteredOptions || this.filteredOptions.length === 0);
        }
    },
    updated: function () {
        var _a, _b;
        if (this.callFocus === true) {
            this.$refs.inputRef.focus();
            this.callFocus = false;
        }
        if (this.open && ((_b = (_a = this.$refs) === null || _a === void 0 ? void 0 : _a.activeOptionRef) === null || _b === void 0 ? void 0 : _b[0]) && isScrollable(this.$refs.listboxRef)) {
            maintainScrollVisibility(this.$refs.activeOptionRef[0], this.$refs.listboxRef);
        }
    },
    methods: {
        onInput: function () {
            var curValue = this.$refs.inputRef.value;
            if (this.inputValue !== curValue) {
                this.inputValue = curValue;
                this.activeIndex = 0;
                /**
                 * emits the current user-provided search string,
                 * primarily useful for making autocomplete calls
                 */
                this.$emit('searchChange', this.inputValue, this.filteredOptions);
            }
            this.determineMenuStateAndNotificationMessage();
        },
        determineMenuStateAndNotificationMessage: function () {
            var newMenuState = true;
            this.notificationMessage = '';
            if (!this.filteredOptions.length) {
                // if there are no filteredOptions, the menu should only remain open when a custom `noResultsMessage` has been provided
                newMenuState = !!this.noResultsMessage;
                this.notificationMessage = this.noResultsMessage || 'no results found';
            }
            if (this.open !== newMenuState) {
                this.updateMenuState(newMenuState, false);
            }
        },
        onInputKeyDown: function (event) {
            var max = this.filteredOptions.length - 1;
            var action = getActionFromKey(event, this.open);
            switch (action) {
                case 4 /* Next */:
                case 3 /* Last */:
                case 2 /* First */:
                case 8 /* Previous */:
                    event.preventDefault();
                    return this.onOptionChange(getUpdatedIndex(this.activeIndex, max, action));
                case 1 /* CloseSelect */:
                    event.preventDefault();
                    return this.updateOption(this.activeIndex);
                case 0 /* Close */:
                    event.preventDefault();
                    return this.updateMenuState(false);
                case 5 /* Open */:
                    return this.updateMenuState(true);
            }
        },
        onInputBlur: function () {
            if (this.ignoreBlur) {
                this.ignoreBlur = false;
                return;
            }
            this.updateMenuState(false, false);
        },
        onOptionChange: function (index) {
            this.activeIndex = index;
        },
        onOptionClick: function (index) {
            this.onOptionChange(index);
            this.updateOption(index);
        },
        onOptionMouseDown: function (event) {
            this.ignoreBlur = true;
            this.callFocus = true;
            event.stopPropagation();
        },
        onMenuMouseDown: function (event) {
            event.preventDefault();
        },
        removeOption: function (index) {
            var _this = this;
            /**
             * emits the most recently removed value,
             * *generally not necessary*, if state can be handled w/ v-model alone
             */
            this.notificationMessage = 'removed';
            this.$emit('remove', this.selectedOptions[index]);
            this.selectedOptions = __spreadArrays(this.selectedOptions.filter(function (_, i) { return i !== index; }));
            setTimeout(function () { _this.notificationMessage = ''; }, 50);
        },
        removeOptionAndHandleFocusShift: function (index) {
            var _this = this;
            this.removeOption(index);
            this.$nextTick(function () {
                if (_this.selectedOptions.length === 0) {
                    _this.$refs.inputRef.focus();
                }
                else {
                    _this.$refs.selectedOptionPill[0].focus();
                }
            });
        },
        selectOption: function (option) {
            /**
             * emits the most recently selected value
             * *generally not necessary*, if state can be handled w/ v-model alone
             */
            if (option) {
                this.$emit('select', option);
                this.selectedOptions = __spreadArrays(this.selectedOptions, [option]);
            }
        },
        updateOption: function (index) {
            var option = this.filteredOptions[index];
            var optionIndex = this.selectedOptions.indexOf(option);
            var isSelected = optionIndex > -1;
            if (isSelected) {
                this.removeOption(optionIndex);
                this.inputValue = '';
            }
            else {
                this.selectOption(option);
                this.inputValue = '';
                this.activeIndex = this.filteredOptions.indexOf(option);
            }
        },
        updateMenuState: function (open, callFocus) {
            if (callFocus === void 0) { callFocus = true; }
            this.open = open;
            this.callFocus = callFocus;
        }
    }
});

/* script */
const __vue_script__$1 = script$1;

/* template */
var __vue_render__$1 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"vue-accessible-select-multi",class:{ disabled: _vm.disabled, open: _vm.open }},[_c('label',{staticClass:"combo-label",class:{ 'sr-only': !_vm.labelIsVisible },attrs:{"id":_vm.htmlId}},[_vm._v("\n\t\t"+_vm._s(_vm.label)+"\n\t")]),_vm._v(" "),_c('ul',{staticClass:"selected-options",class:{ 'below-input': _vm.displayPillsBelowInput },attrs:{"id":(_vm.htmlId + "-selected")}},[_vm._l((_vm.selectedOptions),function(option,index){return [(option[_vm.uniqueIdField])?_c('li',{key:option[_vm.uniqueIdField]},[_c('button',{ref:"selectedOptionPill",refInFor:true,staticClass:"selected-option-pill",attrs:{"disabled":_vm.disabled,"aria-label":("remove " + (option[_vm.labelField])),"type":"button","aria-describedby":(_vm.htmlId + "-selected-option-pills")},on:{"click":function($event){return _vm.removeOptionAndHandleFocusShift(index)}}},[_vm._t("selectedOption",[_vm._v("\n\t\t\t\t\t\t"+_vm._s(option[_vm.labelField])+"\n\t\t\t\t\t")],{"option":option})],2)]):_vm._e()]})],2),_vm._v(" "),_c('div',{staticClass:"combo-wrapper"},[_c('input',{ref:"inputRef",staticClass:"combo-input",attrs:{"aria-activedescendant":_vm.activeId,"aria-autocomplete":"list","aria-controls":(_vm.htmlId + "-listbox"),"aria-expanded":("" + _vm.open),"aria-haspopup":"listbox","aria-labelledby":(_vm.htmlId + " " + _vm.htmlId + "-selected"),"disabled":_vm.disabled,"role":"combobox","type":"text","placeholder":_vm.placeholder},domProps:{"value":_vm.inputValue},on:{"blur":_vm.onInputBlur,"click":function($event){return _vm.updateMenuState(true)},"input":_vm.onInput,"keydown":_vm.onInputKeyDown}}),_vm._v(" "),_c('div',{staticClass:"sr-only",attrs:{"role":"status","aria-live":"polite"}},[(_vm.notificationMessage)?_c('span',[_vm._v(_vm._s(_vm.notificationMessage))]):_vm._e()]),_vm._v(" "),_c('div',{ref:"listboxRef",staticClass:"combo-menu",attrs:{"id":(_vm.htmlId + "-listbox"),"role":"listbox","aria-multiselectable":"true"},on:{"mousedown":_vm.onMenuMouseDown}},[(_vm.filteredOptions)?_vm._l((_vm.filteredOptions),function(option,index){return _c('div',{key:((option[_vm.uniqueIdField]) + "-" + index),ref:_vm.activeIndex === index ? 'activeOptionRef' : null,refInFor:true,class:{
					'option-current': _vm.activeIndex === index,
					'option-selected': _vm.selectedOptions.indexOf(option) > -1,
					'combo-option': true
				},attrs:{"id":(_vm.htmlId + "-" + index),"aria-selected":_vm.selectedOptions.indexOf(option) > -1 ? 'true' : false,"role":"option"},on:{"click":function($event){return _vm.onOptionClick(index)},"mousedown":_vm.onOptionMouseDown}},[_vm._t("option",[_vm._v("\n\t\t\t\t\t"+_vm._s(option[_vm.labelField])+"\n\t\t\t\t")],{"option":option})],2)}):_vm._e(),_vm._v(" "),(_vm.displayNoResultsMessage)?_c('div',{staticClass:"option-no-results"},[_c('span',[_vm._v(_vm._s(_vm.noResultsMessage))])]):_vm._e()],2),_vm._v(" "),_c('div',{staticClass:"combo-input-icon-block"},[(!_vm.loading)?[_vm._t("input-icon",[_c('svg',{staticClass:"combo-plus-icon",attrs:{"viewBox":"0 0 10 10","xmlns":"http://www.w3.org/2000/svg","fill":"currentColor"}},[_c('line',{attrs:{"x1":"5","y1":"0","x2":"5","y2":"10","stroke":"currentColor","stroke-width":"2"}}),_vm._v(" "),_c('line',{attrs:{"x1":"0","y1":"5","x2":"10","y2":"5","stroke":"currentColor","stroke-width":"2"}})])])]:[_c('svg',{staticClass:"combo-spinner-icon",attrs:{"viewBox":"0 0 12 12","fill":"none","xmlns":"http://www.w3.org/2000/svg"}},[_c('path',{attrs:{"d":"M4.44747 0C1.24747 0.887906 -0.651555 4.29399 0.205883 7.6077L1.36471 7.28616C0.678756 4.63519 2.19797 1.91032 4.75798 1.2L4.44747 0Z","fill":"currentColor"}}),_vm._v(" "),_c('path',{attrs:{"d":"M10.6353 4.71384C11.3212 7.36481 9.80202 10.0897 7.24202 10.8L7.55253 12C10.7525 11.1121 12.6516 7.70601 11.7941 4.39231L10.6353 4.71384Z","fill":"currentColor"}})])]],2)])])};
var __vue_staticRenderFns__$1 = [];

  /* style */
  const __vue_inject_styles__$1 = undefined;
  /* scoped */
  const __vue_scope_id__$1 = undefined;
  /* module identifier */
  const __vue_module_identifier__$1 = undefined;
  /* functional template */
  const __vue_is_functional_template__$1 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$1 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$1, staticRenderFns: __vue_staticRenderFns__$1 },
    __vue_inject_styles__$1,
    __vue_script__$1,
    __vue_scope_id__$1,
    __vue_is_functional_template__$1,
    __vue_module_identifier__$1,
    false,
    undefined,
    undefined,
    undefined
  );

export { __vue_component__$1 as SelectMulti, __vue_component__ as SelectSingle };
