import { SelectOption } from './types';
export declare const enum MenuActions {
    Close = 0,
    CloseSelect = 1,
    First = 2,
    Last = 3,
    Next = 4,
    Open = 5,
    PageDown = 6,
    PageUp = 7,
    Previous = 8,
    Select = 9,
    Space = 10,
    Type = 11
}
export declare function filterOptions(options: SelectOption[], filter: string, labelField: string, exclude?: SelectOption[], optionLabelForSearching?: null | ((option: SelectOption) => string)): SelectOption[];
export declare function getActionFromKey(event: KeyboardEvent, menuOpen: boolean, isCurrentOptionDisabled?: boolean): MenuActions | undefined;
export declare function getIndexByLetter(options: SelectOption[], filter: string, labelField: string, startIndex?: number): number;
export declare function getUpdatedIndex(current: number, max: number, action: MenuActions): number;
export declare function isScrollable(element: HTMLElement): boolean;
export declare function maintainScrollVisibility(activeElement: HTMLElement, scrollParent: HTMLElement): number | void;
export declare function uniqueId(): string;
