
// Math.cbrt
/* global CreateMethodProperty */
// 20.2.2.9. Math.cbrt ( x )
CreateMethodProperty(Math, 'cbrt', function cbrt(x) {
	// If x is NaN, the result is NaN.
	if (isNaN(x)) {
		return NaN;
	}
	// If x is +0, the result is +0.
	if (x === 0 && 1/x === Infinity) {
		return 0;
	}
	// If x is -0, the result is -0.
	if (x === 0 && 1/x === -Infinity) {
		return -0;
	}
	// If x is +∞, the result is +∞.
	if (x === Infinity) {
		return Infinity;
	}
	// If x is -∞, the result is -∞.
	if (x === -Infinity) {
		return -Infinity;
	}
	var y = Math.pow(Math.abs(x), 1 / 3);
	return x < 0 ? -y : y;
});
