
// Math.fround
/* global Float32Array, CreateMethodProperty */
// 20.2.2.17 Math.fround ( x )
CreateMethodProperty(Math, 'fround', function (x) {
	// 1. If x is NaN, return NaN.
	if (isNaN(x)) {
		return NaN;
	}
	// 2. If x is one of +0, -0, +∞, -∞, return x.
	if (1 / x === +Infinity || 1 / x === -Infinity || x === +Infinity || x === -Infinity) {
		return x;
	}
	// 3. Let x32 be the result of converting x to a value in IEEE 754-2008 binary32 format using roundTiesToEven.
	// 4. Let x64 be the result of converting x32 to a value in IEEE 754-2008 binary64 format.
	// 5. Return the ECMAScript Number value corresponding to x64.
	return (new Float32Array([x]))[0];
});
