
// Math.imul
/* global CreateMethodProperty, ToUint32 */
// 20.2.2.19. Math.imul ( x, y )
CreateMethodProperty(Math, 'imul', function imul(x, y) {
	// 1. Let a be ToUint32(x).
	var a = ToUint32(x);
	// 2. Let b be ToUint32(y).
	var b = ToUint32(y);
	var UINT16 = 0xffff;
	var aHigh = a >>> 16 & UINT16;
	var aLow = UINT16 & a;
	var bHigh = b >>> 16 & UINT16;
	var bLow = UINT16 & b;
	// the shift by 0 fixes the sign on the high part
	// the final |0 converts the unsigned value into a signed value
	return aLow * bLow + (aHigh * bLow + aLow * bHigh << 16 >>> 0) | 0;
});
