
// Math.log1p
/* global CreateMethodProperty */
// 20.2.2.21. Math.log1p ( x )
CreateMethodProperty(Math, 'log1p', function log1p(x) {
	x = Number(x);
	if (-1 < x && x < 1) {
		// Polyfill.io - For numbers in the range −1 < x < 1
		// Because we are using log, the precision of the result will be identical to log(1).
		// To fix this we avoid using log and use the Taylor Series expansion of log.
		// This series converges when |x| < 1. As we can not sum to infinity,
		// we instead sum the first 300 parts of the series to give a close approximation.
		// |x|<1, log(1+x) = x - x^2/2 + x^3/3 - ... + (-1)^(n-1)*x^n/n + ...
		var y = x;
		for (var i = 2; i <= 300; i++) {
			y += Math.pow((-1), (i - 1)) * Math.pow(x, i) / i;
		}
		return y;
	}

	return Math.log(1 + x);
});
