
// Math.sinh
/* global CreateMethodProperty */
// 20.2.2.31. Math.sinh ( x )
CreateMethodProperty(Math, 'sinh', function sinh(x) {
	var s = (x < 0) ? -1 : 1;
	var absx = Math.abs(x);
	if (absx < 22) {
		if (absx < Math.pow(2, -28)) {
			return x;
		}
		var t = Math.exp(absx) - 1;
		if (absx < 1) {
			return (s * (2 * t - t * t / (t + 1)))/2;
		}
		return (s * (t + t / (t + 1)))/2;
	}
	if (absx < 709.7822265625) {
		return (s * Math.exp(absx))/2;
	}
	var w = Math.exp(0.5 * absx);
	t = (s * w)/2;
	return t * w;
});
