
// Number.isSafeInteger
/* global CreateMethodProperty, Type, ToInteger */
// 20.1.2.5. Number.isSafeInteger ( number )
CreateMethodProperty(Number, 'isSafeInteger', function isSafeInteger(number) {
	// 1. If Type(number) is not Number, return false.
	if (Type(number) !== 'number') {
		return false;
	}
	// 2. If number is NaN, +∞, or -∞, return false.
	if (isNaN(number) || number === Infinity || number === -Infinity) {
		return false;
	}
	// 3. Let integer be ToInteger(number).
	var integer = ToInteger(number);
	// 4. If integer is not equal to number, return false.
	if (integer !== number) {
		return false;
	}
	// 5. If abs(integer) ≤ 2^53-1, return true.
	if (Math.abs(integer) <= (Math.pow(2, 53) - 1)) {
		return true;
	}
	// 6. Otherwise, return false.
	return false;
});
