/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
import * as ts from 'typescript';
export declare abstract class Visitor {
    visitNode(node: ts.Node): void;
    visitChildren(node: ts.Node): void;
    visitAnyKeyword(node: ts.Node): void;
    visitArrayLiteralExpression(node: ts.ArrayLiteralExpression): void;
    visitArrayType(node: ts.ArrayTypeNode): void;
    visitArrowFunction(node: ts.FunctionLikeDeclaration): void;
    visitBinaryExpression(node: ts.BinaryExpression): void;
    visitBindingElement(node: ts.BindingElement): void;
    visitBindingPattern(node: ts.BindingPattern): void;
    visitBlock(node: ts.Block): void;
    visitBreakStatement(node: ts.BreakOrContinueStatement): void;
    visitCallExpression(node: ts.CallExpression): void;
    visitCallSignature(node: ts.SignatureDeclaration): void;
    visitCaseClause(node: ts.CaseClause): void;
    visitClassDeclaration(node: ts.ClassDeclaration): void;
    visitClassExpression(node: ts.ClassExpression): void;
    visitCatchClause(node: ts.CatchClause): void;
    visitConditionalExpression(node: ts.ConditionalExpression): void;
    visitConstructSignature(node: ts.ConstructSignatureDeclaration): void;
    visitConstructorDeclaration(node: ts.ConstructorDeclaration): void;
    visitConstructorType(node: ts.FunctionOrConstructorTypeNode): void;
    visitContinueStatement(node: ts.BreakOrContinueStatement): void;
    visitDebuggerStatement(node: ts.Statement): void;
    visitDefaultClause(node: ts.DefaultClause): void;
    visitDoStatement(node: ts.DoStatement): void;
    visitElementAccessExpression(node: ts.ElementAccessExpression): void;
    visitEnumDeclaration(node: ts.EnumDeclaration): void;
    visitExportAssignment(node: ts.ExportAssignment): void;
    visitExpressionStatement(node: ts.ExpressionStatement): void;
    visitForStatement(node: ts.ForStatement): void;
    visitForInStatement(node: ts.ForInStatement): void;
    visitForOfStatement(node: ts.ForOfStatement): void;
    visitFunctionDeclaration(node: ts.FunctionDeclaration): void;
    visitFunctionExpression(node: ts.FunctionExpression): void;
    visitFunctionType(node: ts.FunctionOrConstructorTypeNode): void;
    visitGetAccessor(node: ts.AccessorDeclaration): void;
    visitIdentifier(node: ts.Identifier): void;
    visitIfStatement(node: ts.IfStatement): void;
    visitImportDeclaration(node: ts.ImportDeclaration): void;
    visitImportEqualsDeclaration(node: ts.ImportEqualsDeclaration): void;
    visitIndexSignatureDeclaration(node: ts.IndexSignatureDeclaration): void;
    visitInterfaceDeclaration(node: ts.InterfaceDeclaration): void;
    visitJsxAttribute(node: ts.JsxAttribute): void;
    visitJsxElement(node: ts.JsxElement): void;
    visitJsxExpression(node: ts.JsxExpression): void;
    visitJsxSelfClosingElement(node: ts.JsxSelfClosingElement): void;
    visitJsxSpreadAttribute(node: ts.JsxSpreadAttribute): void;
    visitLabeledStatement(node: ts.LabeledStatement): void;
    visitMethodDeclaration(node: ts.MethodDeclaration): void;
    visitMethodSignature(node: ts.SignatureDeclaration): void;
    visitModuleDeclaration(node: ts.ModuleDeclaration): void;
    visitNamedImports(node: ts.NamedImports): void;
    visitNamespaceImport(node: ts.NamespaceImport): void;
    visitNewExpression(node: ts.NewExpression): void;
    visitObjectLiteralExpression(node: ts.ObjectLiteralExpression): void;
    visitParameterDeclaration(node: ts.ParameterDeclaration): void;
    visitPostfixUnaryExpression(node: ts.PostfixUnaryExpression): void;
    visitPrefixUnaryExpression(node: ts.PrefixUnaryExpression): void;
    visitPropertyAccessExpression(node: ts.PropertyAccessExpression): void;
    visitPropertyAssignment(node: ts.PropertyAssignment): void;
    visitPropertyDeclaration(node: ts.PropertyDeclaration): void;
    visitPropertySignature(node: ts.Node): void;
    visitRegularExpressionLiteral(node: ts.Node): void;
    visitReturnStatement(node: ts.ReturnStatement): void;
    visitSetAccessor(node: ts.AccessorDeclaration): void;
    visitSourceFile(node: ts.SourceFile): void;
    visitStringLiteral(node: ts.StringLiteral): void;
    visitSwitchStatement(node: ts.SwitchStatement): void;
    visitTemplateExpression(node: ts.TemplateExpression): void;
    visitThrowStatement(node: ts.ThrowStatement): void;
    visitTryStatement(node: ts.TryStatement): void;
    visitTupleType(node: ts.TupleTypeNode): void;
    visitTypeAliasDeclaration(node: ts.TypeAliasDeclaration): void;
    visitTypeAssertionExpression(node: ts.TypeAssertion): void;
    visitTypeLiteral(node: ts.TypeLiteralNode): void;
    visitTypeReference(node: ts.TypeReferenceNode): void;
    visitVariableDeclaration(node: ts.VariableDeclaration): void;
    visitVariableStatement(node: ts.VariableStatement): void;
    visitWhileStatement(node: ts.WhileStatement): void;
    visitWithStatement(node: ts.WithStatement): void;
}
