import * as dom5 from 'dom5';
import { ASTNode } from 'parse5';
import { SourceRange } from '../model/model';
import { Options, ParsedDocument, StringifyOptions } from '../parser/document';
/**
 * The ASTs of the HTML elements needed to represent Polymer elements.
 */
export interface HtmlVisitor {
    (node: ASTNode): void;
}
export declare class ParsedHtmlDocument extends ParsedDocument<ASTNode, HtmlVisitor> {
    type: string;
    constructor(from: Options<ASTNode>);
    visit(visitors: HtmlVisitor[]): void;
    private _sourceRangeForElementWithEndTag(node);
    protected _sourceRangeForNode(node: ASTNode): SourceRange | undefined;
    sourceRangeForAttribute(node: ASTNode, attrName: string): SourceRange | undefined;
    sourceRangeForAttributeName(node: ASTNode, attrName: string): SourceRange | undefined;
    sourceRangeForAttributeValue(node: ASTNode, attrName: string, excludeQuotes?: boolean): SourceRange | undefined;
    sourceRangeForStartTag(node: ASTNode): SourceRange | undefined;
    sourceRangeForEndTag(node: ASTNode): SourceRange | undefined;
    private _getSourceRangeForLocation(location);
    stringify(options?: StringifyOptions): string;
}
export declare function isFakeNode(ast: dom5.Node): boolean;
