"use strict";
/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const fs = require("fs");
const path = require("path");
const javascript_import_scanner_1 = require("../../javascript/javascript-import-scanner");
const javascript_parser_1 = require("../../javascript/javascript-parser");
suite('JavaScriptImportScanner', () => {
    const parser = new javascript_parser_1.JavaScriptParser();
    const scanner = new javascript_import_scanner_1.JavaScriptImportScanner();
    test('finds imports', () => __awaiter(this, void 0, void 0, function* () {
        const file = fs.readFileSync(path.resolve(__dirname, '../static/javascript/module.js'), 'utf8');
        const document = parser.parse(file, '/static/javascript/module.js');
        const visit = (visitor) => Promise.resolve(document.visit([visitor]));
        const { features } = yield scanner.scan(document, visit);
        chai_1.assert.equal(features.length, 1);
        chai_1.assert.equal(features[0].type, 'js-import');
        chai_1.assert.equal(features[0].url, '/static/javascript/submodule.js');
    }));
    test('skips non-path imports', () => __awaiter(this, void 0, void 0, function* () {
        const file = fs.readFileSync(path.resolve(__dirname, '../static/javascript/module-with-named-import.js'), 'utf8');
        const document = parser.parse(file, '/static/javascript/module-with-named-import.js');
        const visit = (visitor) => Promise.resolve(document.visit([visitor]));
        const { features } = yield scanner.scan(document, visit);
        chai_1.assert.equal(features.length, 0);
    }));
});

//# sourceMappingURL=javascript-import-scanner_test.js.map
