"use strict";
/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const esutil_1 = require("../../javascript/esutil");
// See analysis_test for tests of generateElementMetadata
suite('objectKeyToString', function () {
    test('produces expected type names', function () {
        const memberExpression = {
            type: 'MemberExpression',
            object: { type: 'Identifier', name: 'foo' },
            property: { type: 'Identifier', name: 'bar' },
            computed: false
        };
        const afe = {
            type: 'ArrowFunctionExpression',
            expression: true,
            params: [],
            body: { type: 'Identifier', name: 'foo' }
        };
        const inputToOutput = [
            [{ type: 'Identifier', name: 'foo' }, 'foo'],
            [{ type: 'Literal', value: 'foo', raw: '"foo"' }, 'foo'],
            [{ type: 'Literal', value: 10, raw: '10' }, '10'],
            [memberExpression, 'foo.bar'],
            // When it hits an unknown type it returns undefined
            [afe, undefined]
        ];
        for (const testCase of inputToOutput) {
            chai_1.assert.equal(testCase[1], esutil_1.objectKeyToString(testCase[0]));
        }
    });
});

//# sourceMappingURL=esutil_test.js.map
