"use strict";
/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
Object.defineProperty(exports, "__esModule", { value: true });
const ts = require("typescript");
const document_1 = require("../parser/document");
var typescript_visitor_1 = require("./typescript-visitor");
exports.Visitor = typescript_visitor_1.Visitor;
class ParsedTypeScriptDocument extends document_1.ParsedDocument {
    constructor(from) {
        // This constructor is neccessary because the default constructor that
        // TypeScript generates uses spread syntax which in unsupported by node 4.
        super(from);
        this.type = 'typescript';
    }
    visit(visitors) {
        const sourceFile = this.ast;
        for (const visitor of visitors) {
            ts.forEachChild(sourceFile, (node) => visitor.visitNode(node));
        }
    }
    _sourceRangeForNode(_node) {
        // TODO(justinfagnani): implement
        throw new Error('unsupported');
    }
    stringify(_options) {
        // TODO(justinfagnani): implement
        throw new Error('unsupported');
    }
}
exports.ParsedTypeScriptDocument = ParsedTypeScriptDocument;

//# sourceMappingURL=typescript-document.js.map
