/// <reference types="vinyl" />
/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
import File = require('vinyl');
import { UrlLoader } from 'polymer-analyzer';
/**
 * This is a `UrlLoader` for use with a `polymer-analyzer` that reads files
 * that have been gathered by a `BuildBundler` transform stream.
 */
export declare class FileMapUrlLoader implements UrlLoader {
    files: Map<string, File>;
    fallbackLoader?: UrlLoader;
    constructor(files: Map<string, File>, fallbackLoader?: UrlLoader);
    canLoad(url: string): boolean;
    load(url: string): Promise<string>;
}
