import { ASTNode } from 'parse5';
import { Analyzer, Document, ParsedHtmlDocument } from 'polymer-analyzer';
import { AssignedBundle, BundleManifest } from './bundle-manifest';
import { UrlString } from './url-utils';
/**
 * Inline the contents of the html document returned by the link tag's href
 * at the location of the link tag and then remove the link tag.  If the link
 * is a `lazy-import` link, content will not be inlined.
 */
export declare function inlineHtmlImport(analyzer: Analyzer, document: Document, linkTag: ASTNode, stripImports: Set<UrlString>, docBundle: AssignedBundle, manifest: BundleManifest, enableSourcemaps: boolean, rewriteUrlsInTemplates?: boolean, excludes?: string[]): Promise<void>;
/**
 * Inlines the contents of the document returned by the script tag's src url
 * into the script tag content and removes the src attribute.
 */
export declare function inlineScript(analyzer: Analyzer, document: Document, scriptTag: ASTNode, docBundle: AssignedBundle, enableSourcemaps: boolean, excludes?: string[]): Promise<string | undefined>;
/**
 * Inlines the contents of the stylesheet returned by the link tag's href url
 * into a style tag and removes the link tag.
 */
export declare function inlineStylesheet(analyzer: Analyzer, document: Document, cssLink: ASTNode, docBundle: AssignedBundle, excludes?: string[], rewriteUrlsInTemplates?: boolean): Promise<ASTNode | undefined>;
/**
 * Given an import document with a base tag, transform all of its URLs and set
 * link and form target attributes and remove the base tag.
 */
export declare function rewriteAstToEmulateBaseTag(ast: ASTNode, docUrl: UrlString, rewriteUrlsInTemplates?: boolean): void;
/**
 * Walk through an import document, and rewrite all urls so they are
 * correctly relative to the main document url as they've been
 * imported from the import url.
 */
export declare function rewriteAstBaseUrl(ast: ASTNode, oldBaseUrl: UrlString, newBaseUrl: UrlString, rewriteUrlsInTemplates?: boolean): void;
/**
 * Walk through inline scripts of an import document.
 * For each script create identity source maps unless one already exists.
 *
 * The generated script mapping detail is the relative location within
 * the script tag. Later this will be updated to account for the
 * line offset within the final bundle.
 */
export declare function addOrUpdateSourcemapsForInlineScripts(analyzer: Analyzer, originalDoc: Document, reparsedDoc: ParsedHtmlDocument, oldBaseUrl: UrlString): Promise<void[]>;
