import * as ast from './ast';
export interface AstFactory<E extends ast.Expression> {
    empty(): E;
    literal(value: ast.LiteralValue): E;
    id(name: string): E;
    unary(operator: string, expression: E): E;
    binary(left: E, op: string, right: E): E;
    getter(receiver: E, name: string): E;
    invoke(receiver: E, method: string | null, args: Array<E> | null): E;
    paren(child: E): E;
    index(receiver: E, argument: E): E;
    ternary(condition: E, trueExpr: E, falseExpr: E): E;
    map(entries: {
        [key: string]: E;
    } | null): E;
    list(items: Array<E> | null): E;
}
export declare class DefaultAstFactory implements AstFactory<ast.Expression> {
    empty(): ast.Empty;
    literal(value: ast.LiteralValue): ast.Literal;
    id(value: string): ast.ID;
    unary(operator: string, child: ast.Expression): ast.Unary;
    binary(left: ast.Expression, operator: string, right: ast.Expression): ast.Binary;
    getter(receiver: ast.Expression, name: string): ast.Getter;
    invoke(receiver: ast.Expression, method: string | null, args: Array<ast.Expression | null> | null): ast.Invoke;
    paren(child: ast.Expression): ast.Paren;
    index(receiver: ast.Expression, argument: ast.Expression): ast.Index;
    ternary(condition: ast.Expression, trueExpr: ast.Expression, falseExpr: ast.Expression): ast.Ternary;
    map(entries: {
        [key: string]: ast.Expression;
    } | null): ast.Map;
    list(items: Array<ast.Expression> | null): ast.List;
}
