import * as ast from './ast';
import { AstFactory } from './ast_factory';
export interface Scope {
    [key: string]: any;
}
export interface Evaluatable {
    evaluate(this: this, scope: Scope): any;
    getIds(this: this, idents: string[]): string[];
}
export declare type Expression = Literal | Empty | ID | Unary | Binary | Getter | Invoke | Index | Ternary | Map | List;
export interface Literal extends Evaluatable {
    type: 'Literal';
    value: ast.LiteralValue;
}
export interface Empty extends Evaluatable {
    type: 'Empty';
}
export interface ID extends Evaluatable {
    type: 'ID';
    value: string;
}
export interface Unary extends Evaluatable {
    type: 'Unary';
    operator: string;
    child: Expression;
}
export interface Binary extends Evaluatable {
    type: 'Binary';
    operator: string;
    left: Expression;
    right: Expression;
}
export interface Getter extends Evaluatable {
    type: 'Getter';
    receiver: Expression;
    name: string;
}
export interface Invoke extends Evaluatable {
    type: 'Invoke';
    receiver: Expression;
    method: string | null;
    arguments: Array<Expression> | null;
}
export interface Index extends Evaluatable {
    type: 'Index';
    receiver: Expression;
    argument: Expression;
}
export interface Ternary extends Evaluatable {
    type: 'Ternary';
    condition: Expression;
    trueExpr: Expression;
    falseExpr: Expression;
}
export interface Map extends Evaluatable {
    type: 'Map';
    entries: {
        [key: string]: Expression | null;
    } | null;
}
export interface List extends Evaluatable {
    type: 'List';
    items: Array<Expression> | null;
}
export declare class EvalAstFactory implements AstFactory<Expression> {
    empty(): Empty;
    literal(v: string): Literal;
    id(v: string): ID;
    unary(op: string, expr: Expression): Unary;
    binary(l: Expression, op: string, r: Expression): Binary;
    getter(g: Expression, n: string): Getter;
    invoke(receiver: Expression, method: string, args: Expression[]): Invoke;
    paren(e: Expression): Expression;
    index(e: Expression, a: Expression): Index;
    ternary(c: Expression, t: Expression, f: Expression): Ternary;
    map(entries: {
        [key: string]: Expression;
    } | null): Map;
    list(l: Array<Expression> | null): List;
}
