import { Expression } from './ast';
import { AstFactory } from './ast_factory';
import { Kind } from './tokenizer';
export declare function parse(expr: string, astFactory: AstFactory<Expression>): Expression | null;
export declare class Parser<N extends Expression> {
    private _kind;
    private _tokenizer;
    private _ast;
    private _token;
    private _value;
    constructor(input: string, astFactory: AstFactory<N>);
    parse(): N | null;
    private _advance(kind?, value?);
    _matches(kind?: Kind, value?: string): boolean;
    private _parseExpression();
    private _parsePrecedence(left, precedence);
    private _makeInvokeOrGetter(left, right);
    private _parseBinary(left, op);
    private _parseUnary();
    private _parseTernary(condition);
    private _parsePrimary();
    private _parseList();
    private _parseMap();
    private _parseInvokeOrIdentifier();
    private _parseIdentifier();
    private _parseArguments();
    private _parseIndex();
    private _parseParen();
    private _parseString();
    private _parseInteger(prefix?);
    private _parseDecimal(prefix?);
}
