/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   app-drawer/app-drawer.js
 */

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';

import {dom} from '@polymer/polymer/lib/legacy/polymer.dom.js';

import {html} from '@polymer/polymer/lib/utils/html-tag.js';

import {afterNextRender} from '@polymer/polymer/lib/utils/render-status.js';

import {LegacyElementMixin} from '@polymer/polymer/lib/legacy/legacy-element-mixin.js';

/**
 * app-drawer is a navigation drawer that can slide in from the left or right.
 *
 * Example:
 *
 * Align the drawer at the start, which is left in LTR layouts (default):
 *
 * ```html
 * <app-drawer opened></app-drawer>
 * ```
 *
 * Align the drawer at the end:
 *
 * ```html
 * <app-drawer align="end" opened></app-drawer>
 * ```
 *
 * To make the contents of the drawer scrollable, create a wrapper for the scroll
 * content, and apply height and overflow styles to it.
 *
 * ```html
 * <app-drawer>
 *   <div style="height: 100%; overflow: auto;"></div>
 * </app-drawer>
 * ```
 *
 * ### Styling
 *
 * Custom property                  | Description                            | Default
 * ---------------------------------|----------------------------------------|--------------------
 * `--app-drawer-width`             | Width of the drawer                    | 256px
 * `--app-drawer-content-container` | Mixin for the drawer content container | {}
 * `--app-drawer-scrim-background`  | Background for the scrim               | rgba(0, 0, 0, 0.5)
 *
 * *NOTE:** If you use `<app-drawer>` with `<app-drawer-layout>` and specify a
 * value for
 * `--app-drawer-width`, that value must be accessible by both elements. This can
 * be done by defining the value on the `:host` that contains `<app-drawer-layout>`
 * (or `html` if outside a shadow root):
 *
 * ```css
 * :host {
 *   --app-drawer-width: 300px;
 * }
 * ```
 */
interface AppDrawerElement extends LegacyElementMixin, HTMLElement {

  /**
   * The opened state of the drawer.
   */
  opened: boolean|null|undefined;

  /**
   * The drawer does not have a scrim and cannot be swiped close.
   */
  persistent: boolean|null|undefined;

  /**
   * The transition duration of the drawer in milliseconds.
   */
  transitionDuration: number|null|undefined;

  /**
   * The alignment of the drawer on the screen ('left', 'right', 'start' or
   * 'end'). 'start' computes to left and 'end' to right in LTR layout and
   * vice versa in RTL layout.
   */
  align: string|null|undefined;

  /**
   * The computed, read-only position of the drawer on the screen ('left' or
   * 'right').
   */
  readonly position: string|null|undefined;

  /**
   * Create an area at the edge of the screen to swipe open the drawer.
   */
  swipeOpen: boolean|null|undefined;

  /**
   * Trap keyboard focus when the drawer is opened and not persistent.
   */
  noFocusTrap: boolean|null|undefined;

  /**
   * Disables swiping on the drawer.
   */
  disableSwipe: boolean|null|undefined;
  _translateOffset: number;
  _trackDetails: null;
  _drawerState: number;
  _boundEscKeydownHandler: null;
  _firstTabStop: null;
  _lastTabStop: null;
  _MIN_FLING_THRESHOLD: number;
  _MIN_TRANSITION_VELOCITY: number;
  _FLING_TIMING_FUNCTION: string;
  _FLING_INITIAL_SLOPE: number;
  _DRAWER_STATE: object|null;
  attached(): void;
  detached(): void;

  /**
   * Opens the drawer.
   */
  open(): void;

  /**
   * Closes the drawer.
   */
  close(): void;

  /**
   * Toggles the drawer open and close.
   */
  toggle(): void;

  /**
   * Gets the width of the drawer.
   *
   * @returns The width of the drawer in pixels.
   */
  getWidth(): number;
  _isRTL(): any;
  _resetPosition(): void;
  _escKeydownHandler(event: any): void;
  _track(event: any): void;
  _trackStart(event: any): void;
  _trackMove(event: any): void;
  _trackEnd(event: any): void;
  _calculateVelocity(event: any, trackDetails: any): any;
  _flingDrawer(event: any, trackDetails: any): void;
  _styleTransitionDuration(duration: any): void;
  _styleTransitionTimingFunction(timingFunction: any): void;
  _translateDrawer(x: any): void;
  _resetDrawerTranslate(): void;
  _resetDrawerState(): void;

  /**
   * Resets the layout.
   */
  resetLayout(): void;
  _setKeyboardFocusTrap(): void;
  _tabKeydownHandler(event: any): void;
  _openedPersistentChanged(opened: any, persistent: any): void;
}

export {AppDrawerElement};

declare global {

  interface HTMLElementTagNameMap {
    "app-drawer": AppDrawerElement;
  }
}
