/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import '@polymer/iron-flex-layout/iron-flex-layout.js';
import '@polymer/paper-icon-button/paper-icon-button.js';
import '@polymer/paper-fab/paper-fab.js';
import '@polymer/iron-icons/iron-icons.js';
import './shrine-simple-item.js';

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';
import {html} from '@polymer/polymer/lib/utils/html-tag.js';
Polymer({
  _template: html`
    <style>

      :host {
        @apply --layout-horizontal;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      }

      .items {
        -webkit-flex: 1 1 35%;
        flex: 1 1 35%;
        width: 35%;
        overflow-y: auto;
        background-color: #f3f3f3;
        padding-left: 10px;
        padding-right: 10px;
        box-sizing: border-box;
      }

      .itemsGrid {
        @apply --layout-horizontal;
        @apply --layout-wrap;
        @apply --layout-center-justified;
        margin-top: 10px;
      }

      .itemsGrid > .item {
        -webkit-flex: 1 calc(50% - 20px);
        flex: 1 calc(50% - 20px);
        max-width: calc(50% - 20px);
        height: 15vmax;
        min-height: 100px;
        margin: 10px;
        text-decoration: none;
        background-color: white;
      }

      .detailSection {
        @apply --layout;
        width: 65%;
        -webkit-flex: 1 1 65%;
        flex: 1 1 65%;
      }

      .detailGrid {
        width: 100%;
        padding: 128px 0 64px;
        @apply --layout-horizontal;
        @apply --layout-wrap;
        @apply --layout-center-justified;
      }

      .image {
        width: 40vmin;
        position: relative;
      }

      .image img {
        max-height: 100%;
        max-width: 100%;
        width: auto;
      }

      .content {
        width: 400px;
      }

      .store {
        margin-top: 30px;
        border-top: 1px solid #ddd;
      }

      .store h3 {
        font-size: 13px;
        font-weight: 500;
      }

      .info {
        color: rgba(255, 223, 223, 1);
        position: absolute;
        top: 0;
        right: 0;
      }

      .quantitySelector {
        position: relative;
        display: inline-block;
      }

      .quantitySelector::after {
        display: block;
        content: '\\25BC';
        position: absolute;
        top: calc(50% - 8px);
        right: 10px;
        speak: none;
        -webkit-transform: scaleY(.6) scaleX(1);
        transform: scaleY(.6) scaleX(1);
        color: #666;
        pointer-events: none;
      }

      .quantitySelector select {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        padding: 10px 20px;
        border: 1px solid rgba(0, 0, 0, .2);
        background-color: white;
        border-radius: 0;
        position: relative;
        min-width: 180px;
        font-size: 20px;
      }

      .quantitySelector select:focus {
        outline: 0;
        border-color: rgba(0, 0, 0, .5);
      }

      h1 {
        font-family: 'Abril Fatface', cursive;
        font-size: 2.5em;
        font-weight: 300;
        color: #0a3142;
      }

      p {
        font-size: 13px;
        font-weight: 300;
        line-height: 20px;
        color: #333;
      }

      paper-fab {
        --paper-fab-background: #31f0ef;
        --paper-fab-keyboard-focus-background: #21e0df;
        color: #0a3142;
        display: -webkit-inline-flex;
        display: inline-flex;
        margin-left: 20px;
        --paper-fab-iron-icon: {
          width: 20px;
          height: 20px;
        };
      }

      /**
       * Desktop small, tablet
       */
      @media (max-width: 1200px) {
        :host {
          @apply --layout-center;
          @apply --layout-vertical-reverse;
        }

        .items {
          @apply --layout-flex-none;
          width: 100vw;
        }

        .itemsGrid > .item {
          -webkit-flex: 1 calc(33% - 20px);
          flex: 1 calc(33% - 20px);
          max-width: calc(33% - 20px);
          height: 40vmin;
        }

        .detailSection {
          @apply --layout-flex-none;
          width: 90vw;
          margin-left: 10px;
          margin-right: 10px;
        }
      }

      /**
       * Phone
       */
      @media (max-width: 400px) {
        .detailSection {
          @apply --layout-flex-none;
        }

        .itemsGrid > .item {
          -webkit-flex: 1 calc(50% - 20px);
          flex: 1 calc(50% - 20px);
          max-width: calc(50% - 20px);
        }

        h1 {
          text-align: center;
        }

        .detailGrid {
          width: 100%;
          padding: 32px 0 64px;
        }
      }

    </style>

    <div class="items">
      <div class="itemsGrid">
        <template is="dom-repeat" items="[[relatedItems]]">
          <a href\$="#[[section]]/[[item.id]]" title\$="[[item.title]]" class="item">
            <shrine-simple-item item="[[item]]"></shrine-simple-item>
          </a>
        </template>
      </div>
    </div>

    <div class="detailSection">
      <div class="detailGrid">
        <div class="image">
          <img id="img">
          <div class="info">
            <paper-icon-button icon="info-outline" aria-label="More information about the item"></paper-icon-button>
          </div>
        </div>
    
        <div class="content">
          <h1>[[item.title]]</h1>
          <p>[[item.description]]</p>
          <div class="quantitySelector">
            <select aria-label="Change number of items">
              <option value="1">Quantity 1</option>
              <option value="2">Quantity 2</option>
              <option value="3">Quantity 3</option>
              <option value="4">Quantity 4</option>
              <option value="5">Quantity 5</option>
            </select>
          </div>
          <paper-fab mini icon="add-shopping-cart" aria-label="add to the shopping cart"></paper-fab>
          <div class="store">
            <h3>[[item.storeName]]</h3>
            <p>[[item.storeDescription]]</p>
          </div>
        </div>
      </div>
    </div>
`,

  is: 'shrine-detail',

  properties: {

    item: {type: Object, observer: '_itemChanged'},

    section: {type: String},

    relatedItems: {type: Array}

  },

  _itemChanged: function(item) {
    this.$.img.src = '';
    this.$.img.src = item.imageUrl;
  }
});
