import { Polymer } from '../../lib/legacy/polymer-fn.js';
Polymer({
  _template: `
    <x-bar id="bar" prop="{{prop}}" item-prop="{{item.prop}}">
    </x-bar>
`,

  is: 'x-foo',

  properties: {
    prop: {
      notify: true
    },
    itemProp: {
      notify: true
    }
  }
});
Polymer({
  is: 'x-bar',
  properties: {
    prop: {
      notify: true
    },
    itemProp: {
      notify: true
    }
  }
});
Polymer({
  _template: `
    <template is="dom-if" id="if-1" if="{{shouldStamp}}" on-dom-change="domUpdateHandler">
      <!-- Comments should be good -->
      <x-foo on-test1="testHandler1" prop="{{prop}}" item-prop="{{item.prop}}">
      </x-foo>
      <template is="dom-if" id="if-2" if="{{shouldStamp}}">
        <!-- Comments should be good -->
        <x-foo on-test2="testHandler2" prop="{{prop}}" item-prop="{{item.prop}}">
        </x-foo>
        <template is="dom-if" id="if-3" if="{{shouldStamp}}">
        <!-- Comments should be good -->
          <x-foo on-test3="testHandler3" prop="{{prop}}" item-prop="{{item.prop}}">
          </x-foo>
        </template>
      </template>
    </template>
`,

  is: 'x-nested-if',
  testHandler1Count: 0,
  testHandler2Count: 0,
  testHandler3Count: 0,
  domUpdateHandlerCount: 0,

  testHandler1: function() {
    this.testHandler1Count++;
  },

  testHandler2: function() {
    this.testHandler2Count++;
  },

  testHandler3: function() {
    this.testHandler3Count++;
  },

  render: function() {
    this.$['if-1'].render();
  },

  domUpdateHandler: function() {
    this.domUpdateHandlerCount++;
  }
});
Polymer({
  _template: `
    <template is="dom-if" id="if-1" if="{{shouldStamp}}">
      <!-- Comments should be good -->
      <x-foo prop="{{prop}}" item-prop="{{item.prop}}">
      </x-foo>
      <template is="dom-if" id="if-2" if="{{shouldStamp}}">
        <!-- Comments should be good -->
        <x-foo prop="{{prop}}" item-prop="{{item.prop}}">
        </x-foo>
        <template is="dom-if" id="if-3" if="{{shouldStamp}}">
          <!-- Comments should be good -->
          <x-foo prop="{{prop}}" item-prop="{{item.prop}}">
          </x-foo>
        </template>
      </template>
    </template>
`,

  is: 'x-nested-if-configured',

  properties: {
    shouldStamp: {
      value: true
    },
    prop: {
      value: 'outer'
    },
    item: {
      value: function() { return {prop: 'outerItem'}; }
    }
  },

  render: function() {
    this.$['if-1'].render();
  }
});
Polymer({
  _template: `
    <template is="dom-if" id="if-1" if="{{shouldStamp1}}">
      <x-foo prop="{{prop1}}"></x-foo>
      <template is="dom-if" id="if-2" if="{{shouldStamp2}}">
        <x-foo prop="{{prop2}}"></x-foo>
        <template is="dom-if" id="if-3" if="{{shouldStamp3}}">
          <x-foo prop="{{prop3}}"></x-foo>
        </template>
      </template>
    </template>
`,

  is: 'x-nested-if-individual',

  properties: {
    prop1: {
      value: 'prop1'
    },
    prop2: {
      value: 'prop2'
    },
    prop3: {
      value: 'prop3'
    },
    item: {
      value: function() { return {prop: 'outerItem'}; }
    }
  },

  render: function() {
    this.$['if-1'].render();
  }
});
Polymer({
  _template: `
    <template id="domIf" is="dom-if" if="">
      <div>1</div>
      <div>2</div>
      <div>3</div>
      {{text}}
      <div>4</div>
    </template>
`,

  is: 'x-textcontent',

  properties: {
    text: {
      value: 'Stuff'
    }
  }
});
Polymer({
  _template: `
    <template id="domif" is="dom-if" if="">
      <x-client></x-client>
      <x-client></x-client>
      <x-client></x-client>
    </template>
`,

  is: 'x-host'
});
Polymer({
  is: 'x-client',
  statics: {
    uid: 0
  },
  ready: function() {
    this.uid = this.statics.uid++;
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{bool}}" restamp="{{restamp}}">{{guarded(bool)}}</template>
`,

  is: 'x-guard-prop',

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{isTrue(bool)}}" restamp="{{restamp}}">{{guarded(bool)}}</template>
`,

  is: 'x-guard-inline',

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  },

  isTrue: function(val) {
    return val;
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{switch}}" restamp="{{restamp}}">{{guarded(bool)}}</template>
`,

  is: 'x-guard-computed',

  properties: {
    switch: {
      computed: 'computeSwitch(bool)'
    }
  },

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  },

  computeSwitch: function(val) {
    return val;
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{obj.bool}}" restamp="{{restamp}}">{{guarded(obj.bool)}}</template>
`,

  is: 'x-guard-object',

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{switch}}" restamp="{{restamp}}">{{guarded(obj.bool)}}</template>
`,

  is: 'x-guard-object-computed',

  properties: {
    switch: {
      computed: 'computeSwitch(obj.bool)'
    }
  },

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  },

  computeSwitch: function(val) {
    return val;
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{b}}" restamp="{{restamp}}">{{guarded(a)}}</template>
`,

  is: 'x-guard-separate-props',

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  }
});
Polymer({
  _template: `
    <template is="dom-if" if="{{obj.b}}" restamp="{{restamp}}">{{guarded(obj.a)}}</template>
`,

  is: 'x-guard-separate-paths',

  created: function() {
    this.guarded = sinon.spy(function(val) {
      return val;
    });
  }
});
