/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   app-scroll-effects/app-scroll-effects-behavior.html
 */

/// <reference path="../../polymer/types/polymer.d.ts" />
/// <reference path="../../iron-scroll-target-behavior/iron-scroll-target-behavior.d.ts" />
/// <reference path="../helpers/helpers.d.ts" />

declare namespace Polymer {

  /**
   * `Polymer.AppScrollEffectsBehavior` provides an interface that allows an element to use scrolls effects.
   *
   * ### Importing the app-layout effects
   *
   * app-layout provides a set of scroll effects that can be used by explicitly importing
   * `app-scroll-effects.html`:
   *
   * ```html
   * <link rel="import" href="/bower_components/app-layout/app-scroll-effects/app-scroll-effects.html">
   * ```
   *
   * The scroll effects can also be used by individually importing
   * `app-layout/app-scroll-effects/effects/[effectName].html`. For example:
   *
   * ```html
   *  <link rel="import" href="/bower_components/app-layout/app-scroll-effects/effects/waterfall.html">
   * ```
   *
   * ### Consuming effects
   *
   * Effects can be consumed via the `effects` property. For example:
   *
   * ```html
   * <app-header effects="waterfall"></app-header>
   * ```
   *
   * ### Creating scroll effects
   *
   * You may want to create a custom scroll effect if you need to modify the CSS of an element
   * based on the scroll position.
   *
   * A scroll effect definition is an object with `setUp()`, `tearDown()` and `run()` functions.
   *
   * To register the effect, you can use `Polymer.AppLayout.registerEffect(effectName, effectDef)`
   * For example, let's define an effect that resizes the header's logo:
   *
   * ```js
   * Polymer.AppLayout.registerEffect('resizable-logo', {
   *   setUp: function(config) {
   *     // the effect's config is passed to the setUp.
   *     this._fxResizeLogo = { logo: Polymer.dom(this).querySelector('[logo]') };
   *   },
   *
   *   run: function(progress) {
   *      // the progress of the effect
   *      this.transform('scale3d(' + progress + ', '+ progress +', 1)',  this._fxResizeLogo.logo);
   *   },
   *
   *   tearDown: function() {
   *      // clean up and reset of states
   *      delete this._fxResizeLogo;
   *   }
   * });
   * ```
   * Now, you can consume the effect:
   *
   * ```html
   * <app-header id="appHeader" effects="resizable-logo">
   *   <img logo src="logo.svg">
   * </app-header>
   * ```
   *
   * ### Imperative API
   *
   * ```js
   * var logoEffect = appHeader.createEffect('resizable-logo', effectConfig);
   * // run the effect: logoEffect.run(progress);
   * // tear down the effect: logoEffect.tearDown();
   * ```
   *
   * ### Configuring effects
   *
   * For effects installed via the `effects` property, their configuration can be set
   * via the `effectsConfig` property. For example:
   *
   * ```html
   * <app-header effects="waterfall"
   *   effects-config='{"waterfall": {"startsAt": 0, "endsAt": 0.5}}'>
   * </app-header>
   * ```
   *
   * All effects have a `startsAt` and `endsAt` config property. They specify at what
   * point the effect should start and end. This value goes from 0 to 1 inclusive.
   */
  interface AppScrollEffectsBehavior extends Polymer.IronScrollTargetBehavior {

    /**
     * A space-separated list of the effects names that will be triggered when the user scrolls.
     * e.g. `waterfall parallax-background` installs the `waterfall` and `parallax-background`.
     */
    effects: string|null|undefined;

    /**
     * An object that configurates the effects installed via the `effects` property. e.g.
     * ```js
     *  element.effectsConfig = {
     *   "blend-background": {
     *     "startsAt": 0.5
     *   }
     * };
     * ```
     * Every effect has at least two config properties: `startsAt` and `endsAt`.
     * These properties indicate when the event should start and end respectively
     * and relative to the overall element progress. So for example, if `blend-background`
     * starts at `0.5`, the effect will only start once the current element reaches 0.5
     * of its progress. In this context, the progress is a value in the range of `[0, 1]`
     * that indicates where this element is on the screen relative to the viewport.
     */
    effectsConfig: object|null|undefined;

    /**
     * Disables CSS transitions and scroll effects on the element.
     */
    disabled: boolean|null|undefined;

    /**
     * Allows to set a `scrollTop` threshold. When greater than 0, `thresholdTriggered`
     * is true only when the scroll target's `scrollTop` has reached this value.
     *
     * For example, if `threshold = 100`, `thresholdTriggered` is true when the `scrollTop`
     * is at least `100`.
     */
    threshold: number|null|undefined;

    /**
     * True if the `scrollTop` threshold (set in `scrollTopThreshold`) has
     * been reached.
     */
    readonly thresholdTriggered: boolean|null|undefined;

    /**
     * List of effects handlers that will take place during scroll.
     */
    _effectsRunFn: Array<Function|null>|null;

    /**
     * List of the effects definitions installed via the `effects` property.
     */
    _effects: Array<object|null>|null;

    /**
     * The clamped value of `_scrollTop`.
     */
    readonly _clampedScrollTop: any;

    /**
     * Overrides the `_scrollHandler`.
     */
    _scrollHandler(): void;

    /**
     * Updates the scroll state. This method should be overridden
     * by the consumer of this behavior.
     */
    _updateScrollState(scrollTop: number): void;

    /**
     * Returns true if the current element is on the screen.
     * That is, visible in the current viewport. This method should be
     * overridden by the consumer of this behavior.
     */
    isOnScreen(): boolean;

    /**
     * Returns true if there's content below the current element. This method
     * should be overridden by the consumer of this behavior.
     */
    isContentBelow(): boolean;
    detached(): void;

    /**
     * Creates an effect object from an effect's name that can be used to run
     * effects programmatically.
     *
     * @param effectName The effect's name registered via `Polymer.AppLayout.registerEffect`.
     * @param effectConfig The effect config object. (Optional)
     * @returns An effect object with the following functions:
     *
     *  * `effect.setUp()`, Sets up the requirements for the effect.
     *       This function is called automatically before the `effect` function returns.
     *  * `effect.run(progress, y)`, Runs the effect given a `progress`.
     *  * `effect.tearDown()`, Cleans up any DOM nodes or element references used by the effect.
     *
     * Example:
     * ```js
     * var parallax = element.createEffect('parallax-background');
     * // runs the effect
     * parallax.run(0.5, 0);
     * ```
     */
    createEffect(effectName: string, effectConfig?: object|null): object|null;

    /**
     * Called when `effects` or `effectsConfig` changes.
     */
    _effectsChanged(effects: any, effectsConfig: any, isAttached: any): void;

    /**
     * Forces layout
     */
    _layoutIfDirty(): any;

    /**
     * Returns an effect object bound to the current context.
     *
     * @param effectsConfig The effect config object if the effect accepts config values. (Optional)
     */
    _boundEffect(effectDef: object|null, effectsConfig?: object|null): any;

    /**
     * Sets up the effects.
     */
    _setUpEffect(): void;

    /**
     * Tears down the effects.
     */
    _tearDownEffects(): void;

    /**
     * Runs the effects.
     *
     * @param p The progress
     * @param y The top position of the current element relative to the viewport.
     */
    _runEffects(p: number, y: number): void;

    /**
     * Override this method to return a reference to a node in the local DOM.
     * The node is consumed by a scroll effect.
     *
     * @param id The id for the node.
     */
    _getDOMRef(id: string): void;
    _getUndefinedMsg(effectName: any): any;
  }

  const AppScrollEffectsBehavior: object;
}
