# Projects using Popper.js

Popper.js aims to be a foundation block to build powerful libraries on top of it.

In this page we try to collect a list of libraries built with it:

# Integration in frameworks and view libraries

You can easily use Popper.js inside your application written using one of the
most common frameworks or view libraries thank to the following projects.

> We are looking for awesome libraries to integrate Popper.js into other
  frameworks and libraries.
> Have you written an integration library for your favourite framework? Let us know!

## React

### [react-popper](https://github.com/souporserious/react-popper)

React wrapper around Popper.js.

### [ak-layer](https://www.npmjs.com/package/ak-layer)

React wrapper around Popper.js, maintained by [Atlassian](https://www.atlassian.com/).

## AngularJS

### [angular-popper](https://www.npmjs.com/package/angular-popper)

This component is in alpha base, you can contribute to it!

## Vue.js

The Vue.js situation is particular, there are several UI frameworks that use
Popper.js internally, but only few "basic" components that let you use Popper.js with it.

### [vue-popper-component](https://github.com/antongorodezkiy/vue-popper-component)

Simple Vue.js component for Popper.js.

### [vue-directive-tooltip](https://www.npmjs.com/package/vue-directive-tooltip)

Vue.js tooltip directive (based on Popper.js)

## Ember.js

### [ember-popper](https://github.com/kybishop/ember-popper)

An Ember-centric wrapper around Popper.js.

## Preact and Inferno

### [react-popper](https://github.com/souporserious/react-popper)

It is developed for React but it works fine with both Preact and Inferno if
you alias `react` and `react-dom` to `preact-compat` or `inferno-compat`.

# Other projects

### [Tippy.js](https://atomiks.github.io/tippyjs/)

A lightweight, pure JavaScript tooltip library.


-----------

For an always updated list of projects using Popper.js, please visit:

- [npmjs.com depended list](https://www.npmjs.com/browse/depended/popper.js)
- [NPM-Graph list](https://npm-graph.com/NpmPackage/popper.js)

### Want to see your library or project in this page? 

Fork this repository, edit this page and send a Pull Request!
