"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const node_1 = require("servie/dist/node");
exports.Request = node_1.Request;
const throwback_1 = require("throwback");
const popsicle_transport_http_1 = require("popsicle-transport-http");
exports.transport = popsicle_transport_http_1.transport;
exports.HttpResponse = popsicle_transport_http_1.HttpResponse;
const popsicle_cookie_jar_1 = require("popsicle-cookie-jar");
exports.cookies = popsicle_cookie_jar_1.cookies;
const popsicle_content_encoding_1 = require("popsicle-content-encoding");
exports.contentEncoding = popsicle_content_encoding_1.contentEncoding;
const popsicle_redirects_1 = require("popsicle-redirects");
exports.redirects = popsicle_redirects_1.redirects;
const popsicle_user_agent_1 = require("popsicle-user-agent");
exports.userAgent = popsicle_user_agent_1.userAgent;
const common_1 = require("./common");
__export(require("./common"));
__export(require("servie/dist/signal"));
__export(require("servie/dist/headers"));
/**
 * Node.js standard middleware stack.
 */
exports.middleware = throwback_1.compose([
    popsicle_user_agent_1.userAgent(),
    popsicle_content_encoding_1.contentEncoding(),
    // Redirects must happen around cookie support.
    popsicle_redirects_1.redirects(throwback_1.compose([popsicle_cookie_jar_1.cookies(), popsicle_transport_http_1.transport()]))
]);
/**
 * Standard node.js fetch interface.
 */
exports.fetch = common_1.toFetch(exports.middleware, node_1.Request);
//# sourceMappingURL=node.js.map