var url_1 = require('url');
var querystring_1 = require('querystring');
var extend = require('xtend');
function lowerHeader(key) {
    var lower = key.toLowerCase();
    if (lower === 'referrer') {
        return 'referer';
    }
    return lower;
}
function type(str) {
    return str == null ? null : str.split(/ *; */)[0];
}
function stringifyHeader(value) {
    return Array.isArray(value) ? value.join(', ') : String(value);
}
var Base = (function () {
    function Base(_a) {
        var url = _a.url, headers = _a.headers, rawHeaders = _a.rawHeaders, query = _a.query;
        this.Url = {};
        this.headerNames = {};
        this.headerValues = {};
        if (url != null) {
            this.url = url;
        }
        if (query != null) {
            this.query = extend(this.query, typeof query === 'string' ? querystring_1.parse(query) : query);
        }
        if (rawHeaders) {
            for (var i = 0; i < rawHeaders.length; i += 2) {
                var name_1 = rawHeaders[i];
                var value = rawHeaders[i + 1];
                this.append(name_1, value);
            }
        }
        else {
            this.headers = headers;
        }
    }
    Object.defineProperty(Base.prototype, "url", {
        get: function () {
            return url_1.format(this.Url);
        },
        set: function (url) {
            this.Url = url_1.parse(url, true, true);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "query", {
        get: function () {
            return this.Url.query;
        },
        set: function (query) {
            this.Url.query = typeof query === 'string' ? querystring_1.parse(query) : query;
            this.Url.search = null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "headers", {
        get: function () {
            var headers = {};
            for (var _i = 0, _a = Object.keys(this.headerNames); _i < _a.length; _i++) {
                var key = _a[_i];
                headers[key] = this.headerValues[key];
            }
            return headers;
        },
        set: function (headers) {
            this.headerNames = {};
            this.headerValues = {};
            if (headers) {
                for (var _i = 0, _a = Object.keys(headers); _i < _a.length; _i++) {
                    var key = _a[_i];
                    this.set(key, headers[key]);
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Base.prototype.set = function (name, value) {
        var lower = lowerHeader(name);
        if (value == null) {
            delete this.headerNames[lower];
            delete this.headerValues[lower];
        }
        else {
            this.headerNames[lower] = name;
            this.headerValues[lower] = stringifyHeader(value);
        }
        return this;
    };
    Base.prototype.append = function (name, value) {
        var previous = this.get(name);
        if (previous != null) {
            value = previous + ", " + stringifyHeader(value);
        }
        return this.set(name, value);
    };
    Base.prototype.name = function (name) {
        return this.headerNames[lowerHeader(name)];
    };
    Base.prototype.get = function (name) {
        return this.headerValues[lowerHeader(name)];
    };
    Base.prototype.remove = function (name) {
        var lower = lowerHeader(name);
        delete this.headerNames[lower];
        delete this.headerValues[lower];
        return this;
    };
    Base.prototype.type = function (value) {
        if (arguments.length === 0) {
            return type(this.get('Content-Type'));
        }
        return this.set('Content-Type', value);
    };
    return Base;
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = Base;
//# sourceMappingURL=base.js.map