import { Base, BaseOptions, Headers } from './base';
import { Response } from './response';
import PopsicleError from './error';
export interface DefaultsOptions extends BaseOptions {
    method?: string;
    timeout?: number;
    body?: any;
    use?: Middleware[];
    transport?: TransportOptions;
}
export interface RequestOptions extends DefaultsOptions {
    url: string;
    events?: Events;
}
export interface RequestJSON {
    url: string;
    headers: Headers;
    body: any;
    timeout: number;
    method: string;
}
export interface Events {
    abort: EventList<(this: Request) => void>;
    progress: EventList<(this: Request) => void>;
}
export interface TransportOptions {
    open: (request: Request) => Promise<Response>;
    abort?: (request: Request) => any;
    use?: Middleware[];
}
export declare type EventList<T extends (...args: any[]) => void> = Array<EventFn<T>>;
export declare type EventFn<T extends (...args: any[]) => void> = T & {
    listener?: T;
};
export declare type Middleware = (request: Request, next: () => Promise<Response>) => Response | Promise<Response>;
export declare class Request extends Base {
    method: string;
    timeout: number;
    body: any;
    transport: TransportOptions;
    events: Events;
    middleware: Middleware[];
    opened: boolean;
    aborted: boolean;
    uploaded: number;
    downloaded: number;
    uploadedBytes: number;
    downloadedBytes: number;
    uploadLength: number;
    downloadLength: number;
    _raw: any;
    _promise: Promise<Response>;
    constructor(options: RequestOptions);
    error(message: string, code: string, original?: Error): PopsicleError;
    then<T>(onFulfilled?: (response: Response) => T | PromiseLike<T>, onRejected?: (error: PopsicleError) => T | PromiseLike<T>): Promise<T>;
    catch<T>(onRejected: (error: PopsicleError) => T): Promise<T>;
    exec(cb: (error: PopsicleError | null, response?: Response) => void): void;
    toOptions(): RequestOptions;
    toJSON(): RequestJSON;
    clone(): Request;
    use(fn: Middleware | Middleware[]): this;
    on(event: keyof Events, fn: (this: this, ...args: any[]) => void): this;
    off(event: keyof Events, fn: (this: this, ...args: any[]) => void): this;
    once(event: keyof Events, fn: (this: this, ...args: any[]) => void): this;
    emit(event: keyof Events, ...args: any[]): this;
    abort(): this;
    handle(): Promise<never>;
    readonly completed: number;
    readonly completedBytes: number;
    readonly totalBytes: number;
    _setUploadedBytes(bytes: number, uploaded?: number): void;
    _setDownloadedBytes(bytes: number, downloaded?: number): void;
}
