import * as vue from 'vue';
import { Slot, VNode, App } from 'vue';

declare type Name = string | symbol;
interface TransportInput {
    to: Name;
    from: Name;
    order?: number;
    content: Slot;
}
declare type TransportsHub = Map<Name, TransportsByTarget>;
declare type TransportsByTarget = Map<Name, Transport>;
interface Transport {
    to: Name;
    from: Name;
    order: number;
    content: Slot;
}
interface TransportCloser {
    to: Name;
    from?: Name;
}
declare type PortalTargetProps = Partial<{
    multiple: boolean;
    name: Name;
    slotProps: object;
}>;
declare type Wormhole$1 = Readonly<{
    open: (t: TransportInput) => void;
    close: (t: TransportCloser) => void;
    getContentForTarget: (t: Name, returnAll?: boolean) => Transport[];
    transports: TransportsHub;
}>;

declare const _default$1: vue.DefineComponent<{
    disabled: {
        type: BooleanConstructor;
    };
    name: {
        type: (SymbolConstructor | StringConstructor)[];
        default: () => symbol;
    };
    order: {
        type: NumberConstructor;
    };
    slotProps: {
        type: ObjectConstructor;
        default: () => {};
    };
    to: {
        type: StringConstructor;
        default: () => string;
    };
}, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>[] | null, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Record<string, any>, string, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<{
    to: string;
    name: string | symbol;
    disabled: boolean;
    slotProps: Record<string, any>;
} & {
    order?: number | undefined;
}>, {
    to: string;
    name: string | symbol;
    disabled: boolean;
    slotProps: Record<string, any>;
}>;

declare const _default: vue.DefineComponent<{
    multiple: {
        type: BooleanConstructor;
        default: boolean;
    };
    name: {
        type: StringConstructor;
        required: true;
    };
    slotProps: {
        type: ObjectConstructor;
        default: () => {};
    };
}, () => VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>[] | undefined, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, "change"[], "change", vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<{
    multiple: boolean;
    name: string;
    slotProps: Record<string, any>;
} & {}>, {
    multiple: boolean;
    slotProps: Record<string, any>;
}>;

declare function useWormhole(): Readonly<{
    open: (t: TransportInput) => void;
    close: (t: TransportCloser) => void;
    getContentForTarget: (t: Name, returnAll?: boolean | undefined) => Transport[];
    transports: TransportsHub;
}>;
declare function provideWormhole(wormhole: Wormhole$1): void;

declare function createWormhole(asReadonly?: boolean): Wormhole$1;

declare function mountPortalTarget(targetProps: PortalTargetProps, el: HTMLElement | string): void;

interface PluginOptions {
    portalName?: string | false;
    portalTargetName?: string | false;
    MountingPortalName?: string;
    wormhole?: Wormhole$1;
}
declare function install(app: App, options?: PluginOptions): void;
declare const Wormhole: Readonly<{
    open: (t: TransportInput) => void;
    close: (t: TransportCloser) => void;
    getContentForTarget: (t: Name, returnAll?: boolean | undefined) => Transport[];
    transports: TransportsHub;
}>;
declare const version: string | undefined;

export default install;
export { PluginOptions, _default$1 as Portal, _default as PortalTarget, Wormhole$1 as TWormhole, Wormhole, createWormhole, install, mountPortalTarget, provideWormhole, useWormhole, version };
