'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require('postcss-value-parser');

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _convert = require('./lib/convert');

var _convert2 = _interopRequireDefault(_convert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LENGTH_UNITS = ['em', 'ex', 'ch', 'rem', 'vw', 'vh', 'vmin', 'vmax', 'cm', 'mm', 'q', 'in', 'pt', 'pc', 'px'];

function parseWord(node, opts, keepZeroUnit) {
    var pair = (0, _postcssValueParser.unit)(node.value);
    if (pair) {
        var num = Number(pair.number);
        var u = pair.unit.toLowerCase();
        if (num === 0) {
            node.value = keepZeroUnit || !~LENGTH_UNITS.indexOf(u) && u !== '%' ? 0 + u : 0;
        } else {
            node.value = (0, _convert2.default)(num, u, opts);

            if (typeof opts.precision === 'number' && u === 'px' && ~pair.number.indexOf('.')) {
                var precision = Math.pow(10, opts.precision);
                node.value = Math.round(parseFloat(node.value) * precision) / precision + u;
            }
        }
    }
}

function clampOpacity(node) {
    var pair = (0, _postcssValueParser.unit)(node.value);
    if (!pair) {
        return;
    }
    var num = Number(pair.number);
    if (num > 1) {
        node.value = 1 + pair.unit;
    } else if (num < 0) {
        node.value = 0 + pair.unit;
    }
}

function shouldStripPercent(_ref) {
    var value = _ref.value,
        prop = _ref.prop,
        parent = _ref.parent;

    return ~value.indexOf('%') && (prop === 'max-height' || prop === 'height') || parent.parent && parent.parent.name === 'keyframes' && prop === 'stroke-dasharray' || prop === 'stroke-dashoffset' || prop === 'stroke-width';
}

function transform(opts, decl) {
    var prop = decl.prop;

    if (~prop.indexOf('flex') || prop.indexOf('--') === 0) {
        return;
    }

    decl.value = (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        if (node.type === 'word') {
            parseWord(node, opts, shouldStripPercent(decl));
            if (prop === 'opacity' || prop === 'shape-image-threshold') {
                clampOpacity(node);
            }
        } else if (node.type === 'function') {
            if (node.value === 'calc' || node.value === 'hsl' || node.value === 'hsla') {
                (0, _postcssValueParser.walk)(node.nodes, function (n) {
                    if (n.type === 'word') {
                        parseWord(n, opts, true);
                    }
                });
                return false;
            }
            if (node.value === 'url') {
                return false;
            }
        }
    }).toString();
}

var plugin = 'postcss-convert-values';

exports.default = _postcss2.default.plugin(plugin, function () {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { precision: false };

    return function (css) {
        return css.walkDecls(transform.bind(null, opts));
    };
});
module.exports = exports['default'];