'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _postcss = require('postcss');

var _commentRemover = require('./lib/commentRemover');

var _commentRemover2 = _interopRequireDefault(_commentRemover);

var _commentParser = require('./lib/commentParser');

var _commentParser2 = _interopRequireDefault(_commentParser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var space = _postcss.list.space;
exports.default = (0, _postcss.plugin)('postcss-discard-comments', function () {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var remover = new _commentRemover2.default(opts);

    function matchesComments(source) {
        return (0, _commentParser2.default)(source).filter(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 1),
                type = _ref2[0];

            return type;
        });
    }

    function replaceComments(source) {
        var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';

        var parsed = (0, _commentParser2.default)(source).reduce(function (value, _ref3) {
            var _ref4 = _slicedToArray(_ref3, 3),
                type = _ref4[0],
                start = _ref4[1],
                end = _ref4[2];

            var contents = source.slice(start, end);
            if (!type) {
                return value + contents;
            }
            if (remover.canRemove(contents)) {
                return value + separator;
            }
            return `${value}/*${contents}*/`;
        }, '');

        return space(parsed).join(' ');
    }

    return function (css) {
        css.walk(function (node) {
            if (node.type === 'comment' && remover.canRemove(node.text)) {
                node.remove();
                return;
            }

            if (node.raws.between) {
                node.raws.between = replaceComments(node.raws.between);
            }

            if (node.type === 'decl') {
                if (node.raws.value && node.raws.value.raw) {
                    if (node.raws.value.value === node.value) {
                        node.value = replaceComments(node.raws.value.raw);
                    } else {
                        node.value = replaceComments(node.value);
                    }
                    node.raws.value = null;
                }
                if (node.raws.important) {
                    node.raws.important = replaceComments(node.raws.important);
                    var b = matchesComments(node.raws.important);
                    node.raws.important = b.length ? node.raws.important : '!important';
                }
                return;
            }

            if (node.type === 'rule' && node.raws.selector && node.raws.selector.raw) {
                node.raws.selector.raw = replaceComments(node.raws.selector.raw, '');
                return;
            }

            if (node.type === 'atrule') {
                if (node.raws.afterName) {
                    var commentsReplaced = replaceComments(node.raws.afterName);
                    if (!commentsReplaced.length) {
                        node.raws.afterName = commentsReplaced + ' ';
                    } else {
                        node.raws.afterName = ' ' + commentsReplaced + ' ';
                    }
                }
                if (node.raws.params && node.raws.params.raw) {
                    node.raws.params.raw = replaceComments(node.raws.params.raw);
                }
            }
        });
    };
});
module.exports = exports['default'];