'use strict';

exports.__esModule = true;
var important = function important(node) {
    return node.important;
};
var unimportant = function unimportant(node) {
    return !node.important;
};
var hasInherit = function hasInherit(node) {
    return node.value && ~node.value.indexOf('inherit');
};
var hasInitial = function hasInitial(node) {
    return ~node.value.indexOf('initial');
};

exports.default = function () {
    for (var _len = arguments.length, props = Array(_len), _key = 0; _key < _len; _key++) {
        props[_key] = arguments[_key];
    }

    if (props.some(hasInherit) || props.some(hasInitial)) {
        return props.every(hasInherit) || props.every(hasInitial);
    }
    return props.every(unimportant) || props.every(important);
};

module.exports = exports['default'];