'use strict';

exports.__esModule = true;

var _stylehacks = require('stylehacks');

var _canMerge = require('../canMerge');

var _canMerge2 = _interopRequireDefault(_canMerge);

var _getDecls = require('../getDecls');

var _getDecls2 = _interopRequireDefault(_getDecls);

var _minifyTrbl = require('../minifyTrbl');

var _minifyTrbl2 = _interopRequireDefault(_minifyTrbl);

var _parseTrbl = require('../parseTrbl');

var _parseTrbl2 = _interopRequireDefault(_parseTrbl);

var _insertCloned = require('../insertCloned');

var _insertCloned2 = _interopRequireDefault(_insertCloned);

var _mergeRules = require('../mergeRules');

var _mergeRules2 = _interopRequireDefault(_mergeRules);

var _mergeValues = require('../mergeValues');

var _mergeValues2 = _interopRequireDefault(_mergeValues);

var _remove = require('../remove');

var _remove2 = _interopRequireDefault(_remove);

var _trbl = require('../trbl');

var _trbl2 = _interopRequireDefault(_trbl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (prop) {
    var properties = _trbl2.default.map(function (direction) {
        return prop + '-' + direction;
    });

    var cleanup = function cleanup(rule) {
        var decls = (0, _getDecls2.default)(rule, [prop].concat(properties));

        var _loop = function _loop() {
            var lastNode = decls[decls.length - 1];

            // remove properties of lower precedence
            var lesser = decls.filter(function (node) {
                return !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && lastNode.prop === prop && node.prop !== lastNode.prop;
            });

            lesser.forEach(_remove2.default);
            decls = decls.filter(function (node) {
                return !~lesser.indexOf(node);
            });

            // get duplicate properties
            var duplicates = decls.filter(function (node) {
                return !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && node.prop === lastNode.prop;
            });

            duplicates.forEach(_remove2.default);
            decls = decls.filter(function (node) {
                return node !== lastNode && !~duplicates.indexOf(node);
            });
        };

        while (decls.length) {
            _loop();
        }
    };

    var processor = {
        explode: function explode(rule) {
            rule.walkDecls(prop, function (decl) {
                if (~decl.value.indexOf('inherit')) {
                    return;
                }
                if ((0, _stylehacks.detect)(decl)) {
                    return;
                }
                var values = (0, _parseTrbl2.default)(decl.value);
                _trbl2.default.forEach(function (direction, index) {
                    (0, _insertCloned2.default)(decl.parent, decl, {
                        prop: properties[index],
                        value: values[index]
                    });
                });
                decl.remove();
            });
        },
        merge: function merge(rule) {
            (0, _mergeRules2.default)(rule, properties, function (rules, lastNode) {
                if (_canMerge2.default.apply(undefined, rules) && !rules.some(_stylehacks.detect)) {
                    (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                        prop: prop,
                        value: (0, _minifyTrbl2.default)(_mergeValues2.default.apply(undefined, rules))
                    });
                    rules.forEach(_remove2.default);
                    return true;
                }
            });
            cleanup(rule);
        }
    };

    return processor;
};

module.exports = exports['default'];