'use strict';

exports.__esModule = true;

var _postcss = require('postcss');

var _postcssValueParser = require('postcss-value-parser');

var _stylehacks = require('stylehacks');

var _canMerge = require('../canMerge');

var _canMerge2 = _interopRequireDefault(_canMerge);

var _getDecls = require('../getDecls');

var _getDecls2 = _interopRequireDefault(_getDecls);

var _getValue = require('../getValue');

var _getValue2 = _interopRequireDefault(_getValue);

var _mergeRules = require('../mergeRules');

var _mergeRules2 = _interopRequireDefault(_mergeRules);

var _insertCloned = require('../insertCloned');

var _insertCloned2 = _interopRequireDefault(_insertCloned);

var _remove = require('../remove');

var _remove2 = _interopRequireDefault(_remove);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var properties = ['column-width', 'column-count'];
var auto = 'auto';
var inherit = 'inherit';

/**
 * Normalize a columns shorthand definition. Both of the longhand
 * properties' initial values are 'auto', and as per the spec,
 * omitted values are set to their initial values. Thus, we can
 * remove any 'auto' definition when there are two values.
 *
 * Specification link: https://www.w3.org/TR/css3-multicol/
 */

function normalize(values) {
    if (values[0] === auto) {
        return values[1];
    }
    if (values[1] === auto) {
        return values[0];
    }
    if (values[0] === inherit && values[1] === inherit) {
        return inherit;
    }
    return values.join(' ');
}

function explode(rule) {
    rule.walkDecls('columns', function (decl) {
        if ((0, _stylehacks.detect)(decl)) {
            return;
        }
        var values = _postcss.list.space(decl.value);
        if (values.length === 1) {
            values.push(auto);
        }

        values.forEach(function (value, i) {
            var prop = properties[1];

            if (value === auto) {
                prop = properties[i];
            } else if ((0, _postcssValueParser.unit)(value).unit) {
                prop = properties[0];
            }

            (0, _insertCloned2.default)(decl.parent, decl, {
                prop: prop,
                value: value
            });
        });
        decl.remove();
    });
}

function cleanup(rule) {
    var decls = (0, _getDecls2.default)(rule, ['columns'].concat(properties));

    var _loop = function _loop() {
        var lastNode = decls[decls.length - 1];

        // remove properties of lower precedence
        var lesser = decls.filter(function (node) {
            return !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && lastNode.prop === 'columns' && node.prop !== lastNode.prop;
        });

        lesser.forEach(_remove2.default);
        decls = decls.filter(function (node) {
            return !~lesser.indexOf(node);
        });

        // get duplicate properties
        var duplicates = decls.filter(function (node) {
            return !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && node.prop === lastNode.prop;
        });

        duplicates.forEach(_remove2.default);
        decls = decls.filter(function (node) {
            return node !== lastNode && !~duplicates.indexOf(node);
        });
    };

    while (decls.length) {
        _loop();
    }
}

function merge(rule) {
    (0, _mergeRules2.default)(rule, properties, function (rules, lastNode) {
        if (_canMerge2.default.apply(undefined, rules) && !rules.some(_stylehacks.detect)) {
            (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                prop: 'columns',
                value: normalize(rules.map(_getValue2.default))
            });
            rules.forEach(_remove2.default);
            return true;
        }
    });
    cleanup(rule);
}

exports.default = {
    explode: explode,
    merge: merge
};
module.exports = exports['default'];