'use strict';

exports.__esModule = true;
exports.default = mergeRules;

var _hasAllProps = require('./hasAllProps');

var _hasAllProps2 = _interopRequireDefault(_hasAllProps);

var _getDecls = require('./getDecls');

var _getDecls2 = _interopRequireDefault(_getDecls);

var _getRules = require('./getRules');

var _getRules2 = _interopRequireDefault(_getRules);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function mergeRules(rule, properties, callback) {
    var decls = (0, _getDecls2.default)(rule, properties);

    var _loop = function _loop() {
        var last = decls[decls.length - 1];
        var props = decls.filter(function (node) {
            return node.important === last.important;
        });
        var rules = (0, _getRules2.default)(props, properties);

        if (_hasAllProps2.default.apply(undefined, [rules].concat(properties))) {
            if (callback(rules, last, props)) {
                decls = decls.filter(function (node) {
                    return !~rules.indexOf(node);
                });
            }
        }
        decls = decls.filter(function (node) {
            return node !== last;
        });
    };

    while (decls.length) {
        _loop();
    }
}
module.exports = exports['default'];