'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _isCustomProp = require('./isCustomProp');

var _isCustomProp2 = _interopRequireDefault(_isCustomProp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const important = node => node.important;
const unimportant = node => !node.important;
const hasInherit = node => ~node.value.indexOf('inherit');
const hasInitial = node => ~node.value.indexOf('initial');

exports.default = (...props) => {
    if (props.some(hasInherit) || props.some(hasInitial) || props.some(_isCustomProp2.default)) {
        return props.every(hasInherit) || props.every(hasInitial) || props.every(_isCustomProp2.default);
    }
    return props.every(unimportant) || props.every(important);
};

module.exports = exports['default'];