'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _postcss = require('postcss');

var _stylehacks = require('stylehacks');

var _insertCloned = require('../insertCloned');

var _insertCloned2 = _interopRequireDefault(_insertCloned);

var _parseTrbl = require('../parseTrbl');

var _parseTrbl2 = _interopRequireDefault(_parseTrbl);

var _hasAllProps = require('../hasAllProps');

var _hasAllProps2 = _interopRequireDefault(_hasAllProps);

var _getDecls = require('../getDecls');

var _getDecls2 = _interopRequireDefault(_getDecls);

var _getRules = require('../getRules');

var _getRules2 = _interopRequireDefault(_getRules);

var _getValue = require('../getValue');

var _getValue2 = _interopRequireDefault(_getValue);

var _mergeRules = require('../mergeRules');

var _mergeRules2 = _interopRequireDefault(_mergeRules);

var _minifyTrbl = require('../minifyTrbl');

var _minifyTrbl2 = _interopRequireDefault(_minifyTrbl);

var _canMerge = require('../canMerge');

var _canMerge2 = _interopRequireDefault(_canMerge);

var _remove = require('../remove');

var _remove2 = _interopRequireDefault(_remove);

var _trbl = require('../trbl');

var _trbl2 = _interopRequireDefault(_trbl);

var _isCustomProp = require('../isCustomProp');

var _isCustomProp2 = _interopRequireDefault(_isCustomProp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const wsc = ['width', 'style', 'color'];
const defaults = ['medium', 'none', 'currentColor'];

function borderProperty(...parts) {
    return `border-${parts.join('-')}`;
}

function mapBorderProperty(value) {
    return borderProperty(value);
}

const directions = _trbl2.default.map(mapBorderProperty);
const properties = wsc.map(mapBorderProperty);
const directionalProperties = directions.reduce((prev, curr) => prev.concat(wsc.map(prop => `${curr}-${prop}`)), []);

const precedence = [['border'], directions.concat(properties), directionalProperties];

const allProperties = precedence.reduce((a, b) => a.concat(b));

function getLevel(prop) {
    for (let i = 0; i < precedence.length; i++) {
        if (!!~precedence[i].indexOf(prop)) {
            return i;
        }
    }
}

function getColorValue(decl) {
    let values = _postcss.list.space(decl.value);

    if (decl.prop === 'border') {
        return values[2];
    }

    if (!!~directions.indexOf(decl.prop)) {
        return values[2];
    }

    if (decl.prop.substr(-5) === 'color') {
        return decl.value;
    }

    return null;
}

function mergeRedundant({ values, nextValues, decl, nextDecl, index, position, prop }) {
    if ((0, _stylehacks.detect)(decl) || (0, _stylehacks.detect)(nextDecl)) {
        return;
    }
    let props = (0, _parseTrbl2.default)(values[position]);
    props[index] = nextValues[position];
    values.splice(position, 1);
    let borderValue = values.join(' ');
    let propertyValue = (0, _minifyTrbl2.default)(props);

    let origLength = (decl.value + nextDecl.prop + nextDecl.value).length;
    let newLength = borderValue.length + 12 + propertyValue.length;

    if (newLength < origLength) {
        decl.value = borderValue;
        nextDecl.prop = prop;
        nextDecl.value = propertyValue;
    }
}

function isCloseEnough(mapped) {
    return mapped[0] === mapped[1] && mapped[1] === mapped[2] || mapped[1] === mapped[2] && mapped[2] === mapped[3] || mapped[2] === mapped[3] && mapped[3] === mapped[0] || mapped[3] === mapped[0] && mapped[0] === mapped[1];
}

function getDistinctShorthands(mapped) {
    return mapped.reduce((a, b) => {
        a = Array.isArray(a) ? a : [a];
        if (!~a.indexOf(b)) {
            a.push(b);
        }
        return a;
    });
}

function explode(rule) {
    rule.walkDecls(/^border/, decl => {
        // Don't explode inherit values as they cannot be merged together
        if (decl.value === 'inherit') {
            return;
        }

        if ((0, _stylehacks.detect)(decl)) {
            return;
        }

        const { prop } = decl;
        // border -> border-trbl
        if (prop === 'border') {
            directions.forEach(direction => {
                (0, _insertCloned2.default)(decl.parent, decl, { prop: direction });
            });
            return decl.remove();
        }
        // border-trbl -> border-trbl-wsc
        if (directions.some(direction => prop === direction)) {
            let values = _postcss.list.space(decl.value);
            wsc.forEach((d, i) => {
                (0, _insertCloned2.default)(decl.parent, decl, {
                    prop: `${prop}-${d}`,
                    value: values[i] || defaults[i]
                });
            });
            return decl.remove();
        }
        // border-wsc -> border-trbl-wsc
        wsc.some(style => {
            if (prop !== borderProperty(style)) {
                return false;
            }
            (0, _parseTrbl2.default)(decl.value).forEach((value, i) => {
                (0, _insertCloned2.default)(decl.parent, decl, {
                    prop: borderProperty(_trbl2.default[i], style),
                    value
                });
            });
            return decl.remove();
        });
    });
}

function merge(rule) {
    // border-trbl-wsc -> border-trbl
    _trbl2.default.forEach(direction => {
        const prop = borderProperty(direction);
        (0, _mergeRules2.default)(rule, wsc.map(style => borderProperty(direction, style)), (rules, lastNode) => {
            if ((0, _canMerge2.default)(...rules) && !rules.some(_stylehacks.detect)) {
                (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                    prop,
                    value: rules.map(_getValue2.default).join(' ')
                });
                rules.forEach(_remove2.default);
                return true;
            }
        });
    });

    // border-trbl-wsc -> border-wsc
    wsc.forEach(style => {
        const prop = borderProperty(style);
        (0, _mergeRules2.default)(rule, _trbl2.default.map(direction => borderProperty(direction, style)), (rules, lastNode) => {
            if ((0, _canMerge2.default)(...rules) && !rules.some(_stylehacks.detect)) {
                (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                    prop,
                    value: (0, _minifyTrbl2.default)(rules.map(_getValue2.default).join(' '))
                });
                rules.forEach(_remove2.default);
                return true;
            }
        });
    });

    // border-trbl -> border-wsc
    (0, _mergeRules2.default)(rule, directions, (rules, lastNode) => {
        if (rules.some(_stylehacks.detect)) {
            return;
        }
        wsc.forEach((d, i) => {
            (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                prop: borderProperty(d),
                value: (0, _minifyTrbl2.default)(rules.map(node => _postcss.list.space(node.value)[i]))
            });
        });
        rules.forEach(_remove2.default);
        return true;
    });

    // border-wsc -> border
    // border-wsc -> border + border-color
    // border-wsc -> border + border-dir
    (0, _mergeRules2.default)(rule, properties, (rules, lastNode) => {
        if (rules.some(_stylehacks.detect)) {
            return;
        }
        const [width, style, color] = rules;
        const values = rules.map(node => (0, _parseTrbl2.default)(node.value));
        const mapped = [0, 1, 2, 3].map(i => [values[0][i], values[1][i], values[2][i]].join(' '));
        const reduced = getDistinctShorthands(mapped);

        if (isCloseEnough(mapped) && (0, _canMerge2.default)(...rules)) {
            const first = mapped.indexOf(reduced[0]) !== mapped.lastIndexOf(reduced[0]);

            const border = (0, _insertCloned2.default)(lastNode.parent, lastNode, {
                prop: 'border',
                value: first ? reduced[0] : reduced[1]
            });

            if (reduced[1]) {
                const value = first ? reduced[1] : reduced[0];
                const prop = borderProperty(_trbl2.default[mapped.indexOf(value)]);

                rule.insertAfter(border, Object.assign(lastNode.clone(), {
                    prop,
                    value
                }));
            }
            rules.forEach(_remove2.default);
            return true;
        } else if (reduced.length === 1) {
            rule.insertBefore(color, Object.assign(lastNode.clone(), {
                prop: 'border',
                value: [width, style].map(_getValue2.default).join(' ')
            }));
            rules.filter(node => node.prop !== properties[2]).forEach(_remove2.default);
            return true;
        }
    });

    // border-wsc -> border + border-trbl
    (0, _mergeRules2.default)(rule, properties, (rules, lastNode) => {
        if (rules.some(_stylehacks.detect)) {
            return;
        }
        const values = rules.map(node => (0, _parseTrbl2.default)(node.value));
        const mapped = [0, 1, 2, 3].map(i => [values[0][i], values[1][i], values[2][i]].join(' '));
        const reduced = getDistinctShorthands(mapped);
        const none = 'none none currentColor';

        if (reduced.length === 2 && reduced[0] === none || reduced[1] === none) {
            const noOfNones = mapped.filter(value => value === none).length;
            rule.insertBefore(lastNode, Object.assign(lastNode.clone(), {
                prop: 'border',
                value: noOfNones > 2 ? 'none' : mapped.filter(value => value !== none)[0]
            }));
            directions.forEach((dir, i) => {
                if (noOfNones > 2 && mapped[i] !== none) {
                    rule.insertBefore(lastNode, Object.assign(lastNode.clone(), {
                        prop: dir,
                        value: mapped[i]
                    }));
                }
                if (noOfNones <= 2 && mapped[i] === none) {
                    rule.insertBefore(lastNode, Object.assign(lastNode.clone(), {
                        prop: dir,
                        value: 'none'
                    }));
                }
            });
            rules.forEach(_remove2.default);
            return true;
        }
    });

    // optimize border-trbl
    let decls = (0, _getDecls2.default)(rule, directions);
    while (decls.length) {
        const lastNode = decls[decls.length - 1];
        wsc.forEach((d, i) => {
            const names = directions.filter(name => name !== lastNode.prop).map(name => `${name}-${d}`);
            const props = rule.nodes.filter(node => node.prop && ~names.indexOf(node.prop) && node.important === lastNode.important);
            const rules = (0, _getRules2.default)(props, names);
            if ((0, _hasAllProps2.default)(rules, ...names) && !rules.some(_stylehacks.detect)) {
                const values = rules.map(node => node ? node.value : null);
                const filteredValues = values.filter(Boolean);
                const lastNodeValue = _postcss.list.space(lastNode.value)[i];
                values[directions.indexOf(lastNode.prop)] = lastNodeValue;
                let value = (0, _minifyTrbl2.default)(values.join(' '));
                if (filteredValues[0] === filteredValues[1] && filteredValues[1] === filteredValues[2]) {
                    value = filteredValues[0];
                }
                let refNode = props[props.length - 1];
                if (value === lastNodeValue) {
                    refNode = lastNode;
                    let valueArray = _postcss.list.space(lastNode.value);
                    valueArray.splice(i, 1);
                    lastNode.value = valueArray.join(' ');
                }
                (0, _insertCloned2.default)(refNode.parent, refNode, {
                    prop: borderProperty(d),
                    value
                });
                decls = decls.filter(node => !~rules.indexOf(node));
                rules.forEach(_remove2.default);
            }
        });
        decls = decls.filter(node => node !== lastNode);
    }

    rule.walkDecls('border', decl => {
        const nextDecl = decl.next();
        if (!nextDecl || nextDecl.type !== 'decl') {
            return;
        }
        const index = directions.indexOf(nextDecl.prop);
        if (!~index) {
            return;
        }
        const values = _postcss.list.space(decl.value);
        const nextValues = _postcss.list.space(nextDecl.value);

        const config = {
            values,
            nextValues,
            decl,
            nextDecl,
            index
        };

        if (values[0] === nextValues[0] && values[2] === nextValues[2]) {
            return mergeRedundant(Object.assign({}, config, {
                position: 1,
                prop: 'border-style'
            }));
        }

        if (values[1] === nextValues[1] && values[2] === nextValues[2]) {
            return mergeRedundant(Object.assign({}, config, {
                position: 0,
                prop: 'border-width'
            }));
        }

        if (values[0] === nextValues[0] && values[1] === nextValues[1] && values[2] && nextValues[2]) {
            return mergeRedundant(Object.assign({}, config, {
                position: 2,
                prop: 'border-color'
            }));
        }
    });

    // clean-up values
    rule.walkDecls(/^border($|-(top|right|bottom|left))/, decl => {
        const value = [..._postcss.list.space(decl.value), ''].reduceRight((prev, cur, i) => {
            if (prev === '' && cur === defaults[i]) {
                return prev;
            }
            return cur + ' ' + prev;
        }).trim() || defaults[0];
        decl.value = (0, _minifyTrbl2.default)(value);
    });

    // border-spacing-hv -> border-spacing
    rule.walkDecls('border-spacing', decl => {
        const value = _postcss.list.space(decl.value);

        // merge vertical and horizontal dups
        if (value.length > 1 && value[0] === value[1]) {
            decl.value = value.slice(1).join(' ');
        }
    });

    // clean-up rules
    decls = (0, _getDecls2.default)(rule, allProperties);
    while (decls.length) {
        const lastNode = decls[decls.length - 1];

        // remove properties of lower precedence
        const lesser = decls.filter(node => !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && getLevel(node.prop) > getLevel(lastNode.prop));

        lesser.forEach(_remove2.default);
        decls = decls.filter(node => !~lesser.indexOf(node));

        // get duplicate properties
        let duplicates = decls.filter(node => !(0, _stylehacks.detect)(lastNode) && !(0, _stylehacks.detect)(node) && node !== lastNode && node.important === lastNode.important && node.prop === lastNode.prop && !(!(0, _isCustomProp2.default)(node) && (0, _isCustomProp2.default)(lastNode)));

        if (duplicates.length) {
            if (/hsla|rgba/.test(getColorValue(lastNode))) {
                const preserve = duplicates.filter(node => !/hsla|rgba/.test(getColorValue(node))).pop();
                duplicates = duplicates.filter(node => node !== preserve);
            }
            duplicates.forEach(_remove2.default);
        }
        decls = decls.filter(node => node !== lastNode && !~duplicates.indexOf(node));
    }
}

exports.default = {
    explode,
    merge
};
module.exports = exports['default'];